/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.tool.xmlsectool;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.ConstraintViolationException;
import net.shibboleth.shared.xml.SchemaBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class SchemaValidator {
    private final Logger log = LoggerFactory.getLogger(SchemaValidator.class);
    private final Schema schema;

    public SchemaValidator(@Nonnull SchemaBuilder.SchemaLanguage schemaLanguage, @Nonnull File schemaLocation) throws SAXException {
        Constraint.isNotNull((Object)schemaLanguage, (String)"schema language must not be null");
        Constraint.isNotNull((Object)schemaLocation, (String)"schema location must not be null");
        SchemaBuilder builder = new SchemaBuilder();
        builder.setSchemaLanguage(schemaLanguage);
        ArrayList<File> schemaFiles = new ArrayList<File>();
        this.getSchemaFiles(schemaLanguage, new File[]{schemaLocation}, schemaFiles);
        for (File schemaFile : schemaFiles) {
            builder.addSchema((Source)new StreamSource(schemaFile));
        }
        this.schema = builder.buildSchema();
    }

    private String schemaFileExtension(@Nonnull SchemaBuilder.SchemaLanguage schemaLanguage) {
        switch (schemaLanguage) {
            case XML: {
                return ".xsd";
            }
            case RELAX: {
                return ".rng";
            }
        }
        throw new ConstraintViolationException("unknown schema language");
    }

    protected void getSchemaFiles(@Nonnull SchemaBuilder.SchemaLanguage lang, File[] schemaFilesOrDirectories, List<File> accumulatedSchemaFiles) {
        Constraint.isNotNull((Object)lang, (String)"Schema language may not be null");
        if (schemaFilesOrDirectories == null || schemaFilesOrDirectories.length == 0) {
            return;
        }
        for (File handle : schemaFilesOrDirectories) {
            if (handle == null) continue;
            if (!handle.canRead()) {
                this.log.debug("Ignoring '{}', no read permission", (Object)handle.getAbsolutePath());
            }
            if (handle.isFile() && handle.getName().endsWith(this.schemaFileExtension(lang))) {
                this.log.debug("Added schema source '{}'", (Object)handle.getAbsolutePath());
                accumulatedSchemaFiles.add(handle);
            }
            if (!handle.isDirectory()) continue;
            this.getSchemaFiles(lang, handle.listFiles(), accumulatedSchemaFiles);
        }
    }

    public void validate(@Nonnull Source document) throws SAXException, IOException {
        Validator validator = this.schema.newValidator();
        validator.validate(document);
    }
}

