/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.tool.xmlsectool;

import java.io.PrintStream;
import java.util.Set;
import java.util.TreeSet;
import net.shibboleth.tool.xmlsectool.DigestChoice;

public class DisallowedAlgorithms {
    private final Set<String> digestAlgorithms = new TreeSet<String>();
    private final Set<String> signatureAlgorithms = new TreeSet<String>();

    public DisallowedAlgorithms() {
        this.digestAlgorithms.add("http://www.w3.org/2001/04/xmldsig-more#md5");
        this.signatureAlgorithms.add("http://www.w3.org/2001/04/xmldsig-more#rsa-md5");
        this.disallowDigest(DigestChoice.SHA1);
    }

    public void disallowDigest(DigestChoice digestChoice) {
        this.digestAlgorithms.add(digestChoice.getDigestAlgorithm());
        this.signatureAlgorithms.add(digestChoice.getRSAAlgorithm());
        this.signatureAlgorithms.add(digestChoice.getECDSAAlgorithm());
    }

    public void allowDigest(DigestChoice digestChoice) {
        this.digestAlgorithms.remove(digestChoice.getDigestAlgorithm());
        this.signatureAlgorithms.remove(digestChoice.getRSAAlgorithm());
        this.signatureAlgorithms.remove(digestChoice.getECDSAAlgorithm());
    }

    public boolean isDigestAlgorithmDisallowed(String alg) {
        return this.digestAlgorithms.contains(alg);
    }

    public boolean isSignatureAlgorithmDisallowed(String alg) {
        return this.signatureAlgorithms.contains(alg);
    }

    public void allowAllDigests() {
        this.digestAlgorithms.clear();
        this.signatureAlgorithms.clear();
    }

    public void list(PrintStream out) {
        out.println("Disallowed digest algorithms:");
        if (this.digestAlgorithms.isEmpty()) {
            out.println("   (none)");
        } else {
            for (String uri : this.digestAlgorithms) {
                out.println("   " + uri);
            }
        }
        out.println();
        out.println("Disallowed signature algorithms:");
        if (this.signatureAlgorithms.isEmpty()) {
            out.println("   (none)");
        } else {
            for (String uri : this.signatureAlgorithms) {
                out.println("   " + uri);
            }
        }
        out.println();
    }
}

