/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.tool.xmlsectool;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.security.x509.X509Support;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CredentialHelper {
    private static final Logger LOG = LoggerFactory.getLogger(CredentialHelper.class);

    private CredentialHelper() {
    }

    @Nonnull
    protected static BasicX509Credential getFileBasedCredentials(String keyFile, String keyPassword, String certificateFile) throws KeyException, CertificateException {
        LOG.debug("Reading PEM/DER encoded credentials from the filesystem");
        LOG.debug("Reading certificates from file {}", (Object)certificateFile);
        Collection certificates = X509Support.decodeCertificates((File)new File(certificateFile));
        X509Certificate entityCertificate = (X509Certificate)certificates.iterator().next();
        BasicX509Credential credential = new BasicX509Credential(entityCertificate);
        credential.setEntityCertificateChain(certificates);
        LOG.debug("Certificates successfully read");
        if (keyFile != null) {
            LOG.debug("Reading private key from file {}", (Object)keyFile);
            if (keyPassword == null) {
                credential.setPrivateKey(KeySupport.decodePrivateKey((File)new File(keyFile), null));
            } else {
                credential.setPrivateKey(KeySupport.decodePrivateKey((File)new File(keyFile), (char[])keyPassword.toCharArray()));
            }
            LOG.debug("Private key succesfully read");
        }
        return credential;
    }

    @Nonnull
    protected static BasicX509Credential getKeystoreCredential(String keystorePath, String keystorePassword, String keystoreProvider, String keystoreType, String keyAlias, String keyPassword) throws IOException, GeneralSecurityException {
        String storePassword;
        LOG.debug("Reading credentials from keystore");
        String storeType = keystoreType;
        if (storeType == null) {
            storeType = KeyStore.getDefaultType();
        }
        if ((storePassword = keystorePassword) == null) {
            storePassword = keyPassword;
        }
        KeyStore keystore = keystoreProvider != null ? KeyStore.getInstance(storeType, keystoreProvider) : KeyStore.getInstance(storeType);
        keystore.load(new FileInputStream(keystorePath), storePassword.toCharArray());
        return CredentialHelper.getCredentialFromKeystore(keystore, keyAlias, keyPassword);
    }

    private static void dumpSecurityProviders(@Nonnull String message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(message);
            for (Provider provider : Security.getProviders()) {
                LOG.debug("   available security provider: {}", (Object)provider.getName());
            }
        }
    }

    protected static BasicX509Credential getPKCS11Credential(String pkcs11Config, String keyAlias, String keyPassword) throws IOException, GeneralSecurityException {
        CredentialHelper.dumpSecurityProviders("Acquiring PKCS11 keystore");
        if (!new File(pkcs11Config).exists()) {
            LOG.error("PKCS#11 configuration file '{}' does not exist", (Object)pkcs11Config);
            throw new IOException("PKCS#11 configuration file '" + pkcs11Config + "' does not exist");
        }
        try {
            LOG.debug("Creating PKCS11 keystore with configuration file {}", (Object)pkcs11Config);
            Provider baseProvider = Security.getProvider("SunPKCS11");
            if (baseProvider == null) {
                throw new NoSuchProviderException("could not acquire unconfigured PKCS#11 provider");
            }
            LOG.debug("Unconfigured PKCS#11 provider: " + baseProvider.getName());
            Provider pkcs11Provider = baseProvider.configure(pkcs11Config);
            LOG.debug("Configured PKCS#11 provider: " + pkcs11Provider.getName());
            Security.addProvider(pkcs11Provider);
            KeyStore keystore = KeyStore.getInstance("PKCS11", pkcs11Provider);
            LOG.debug("Initializing PKCS11 keystore");
            keystore.load(null, keyPassword.toCharArray());
            return CredentialHelper.getCredentialFromKeystore(keystore, keyAlias, keyPassword);
        }
        catch (Exception e) {
            LOG.error("Unable to read PKCS11 keystore: {}", (Object)e.getMessage());
            throw new IOException("Unable to read PKCS11 keystore", e);
        }
    }

    protected static BasicX509Credential getCredentialFromKeystore(KeyStore keystore, String keyAlias, String keyPassword) throws GeneralSecurityException {
        BasicX509Credential credential;
        KeyStore.Entry keyEntry = keystore.getEntry(keyAlias, new KeyStore.PasswordProtection(keyPassword.toCharArray()));
        if (keyEntry == null) {
            throw new KeyStoreException("entry '" + keyAlias + "' not found in keystore");
        }
        if (keyEntry instanceof KeyStore.PrivateKeyEntry) {
            KeyStore.PrivateKeyEntry privKeyEntry = (KeyStore.PrivateKeyEntry)keyEntry;
            List<X509Certificate> certChain = Arrays.asList((X509Certificate[])privKeyEntry.getCertificateChain());
            credential = new BasicX509Credential((X509Certificate)privKeyEntry.getCertificate());
            credential.setEntityCertificateChain(certChain);
            credential.setPrivateKey(privKeyEntry.getPrivateKey());
        } else if (keyEntry instanceof KeyStore.TrustedCertificateEntry) {
            KeyStore.TrustedCertificateEntry certEntry = (KeyStore.TrustedCertificateEntry)keyEntry;
            credential = new BasicX509Credential((X509Certificate)certEntry.getTrustedCertificate());
        } else {
            throw new CertificateException("unknown type of key entry in keystore");
        }
        LOG.debug("Successfully read credentials from keystore");
        return credential;
    }
}

