/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.saml.saml2.profile.impl;

import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.sp.saml.saml2.context.SAMLTokenContext;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.slf4j.Logger;

public class SAMLTokenContextConsumer
implements BiConsumer<ProfileRequestContext, AuthnStatement> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SAMLTokenContextConsumer.class);

    @Override
    public void accept(@Nullable ProfileRequestContext profileRequestContext, @Nullable AuthnStatement statement) {
        if (profileRequestContext == null || statement == null) {
            this.log.error("ProfileRequestContext or statement were null");
            return;
        }
        SAMLTokenContext tokenContext = (SAMLTokenContext)profileRequestContext.ensureSubcontext(SAMLTokenContext.class);
        tokenContext.setAuthnStatement(statement);
        XMLObject xMLObject = statement.getParent();
        if (xMLObject instanceof Assertion) {
            Assertion assertion = (Assertion)xMLObject;
            tokenContext.setSubject(assertion.getSubject());
        }
    }
}

