/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.saml.saml2.profile.impl;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.codec.EncodingException;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.xml.SerializeSupport;
import net.shibboleth.sp.profile.AbstractTokenConsumerResponseAction;
import net.shibboleth.sp.saml.saml2.context.SAMLTokenContext;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Subject;
import org.slf4j.Logger;
import org.w3c.dom.Node;

public class PrepareAgentResponse
extends AbstractTokenConsumerResponseAction {
    @Nonnull
    private static final Map<String, Object> NO_XML_DECL_PARAMS = CollectionSupport.singletonMap((Object)"xml-declaration", (Object)Boolean.FALSE);
    @Nonnull
    private Logger log = LoggerFactory.getLogger(PrepareAgentResponse.class);
    @Nonnull
    private Function<ProfileRequestContext, SAMLTokenContext> samlTokenContextLookupStrategy = new ChildContextLookup(SAMLTokenContext.class);
    @NonnullBeforeExec
    private SAMLTokenContext samlTokenContext;

    public PrepareAgentResponse() {
        this.setAttributeContextLookupStrategy(new ChildContextLookup(AttributeContext.class).compose((Function)new ChildContextLookup(SAMLTokenContext.class)));
    }

    public void setSAMLTokenContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLTokenContext> strategy) {
        this.checkSetterPreconditions();
        this.samlTokenContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SAMLTokenContext lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.samlTokenContext = this.samlTokenContextLookupStrategy.apply(profileRequestContext);
        if (this.samlTokenContext == null) {
            this.log.warn("{} No SAMLTokenContext found", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        return true;
    }

    @Nullable
    protected String getSessionData(@Nonnull ProfileRequestContext profileRequestContext) {
        String sessionIndex;
        NameID nameID;
        Subject subject = this.samlTokenContext.getSubject();
        NameID nameID2 = nameID = subject != null ? subject.getNameID() : null;
        if (nameID == null) {
            this.log.debug("{} No NameID found in assertion, no session data to attach", (Object)this.getLogPrefix());
            return null;
        }
        AuthnStatement statement = this.samlTokenContext.getAuthnStatement();
        String string = sessionIndex = statement != null ? statement.getSessionIndex() : null;
        if (sessionIndex != null) {
            nameID.setSPProvidedID(sessionIndex);
        }
        try {
            String xml = SerializeSupport.nodeToString((Node)XMLObjectSupport.marshall((XMLObject)nameID), NO_XML_DECL_PARAMS);
            return Base64Support.encodeURLSafe((byte[])xml.getBytes(StandardCharsets.UTF_8));
        }
        catch (EncodingException | MarshallingException e) {
            this.log.error("{} Error marshalling and encoding NameID", (Object)this.getLogPrefix(), (Object)e);
            return null;
        }
    }
}

