/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.saml.saml2.profile.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.AttributeDecodingException;
import net.shibboleth.idp.attribute.DateTimeAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeSupport;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.attribute.filter.AttributeFilter;
import net.shibboleth.idp.attribute.filter.AttributeFilterException;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoder;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoderRegistry;
import net.shibboleth.idp.attribute.transcoding.TranscoderSupport;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.context.navigate.IssuerLookupFunction;
import net.shibboleth.profile.context.navigate.RelyingPartyIdLookupFunction;
import net.shibboleth.saml.profile.context.navigate.SAMLMetadataContextLookupFunction;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.service.ServiceException;
import net.shibboleth.shared.service.ServiceableComponent;
import net.shibboleth.sp.profile.AbstractApplicationAction;
import net.shibboleth.sp.saml.saml2.context.SAMLTokenContext;
import net.shibboleth.sp.saml.saml2.profile.config.BrowserSSOProfileConfiguration;
import org.opensaml.core.xml.schema.XSURI;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.RecursiveTypedParentContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AuthnContext;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnContextDeclRef;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.StatusResponseType;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectLocality;
import org.slf4j.Logger;

public class ExtractSAMLAttributes
extends AbstractApplicationAction {
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_METRIC_NAME = "net.shibboleth.idp.authn.saml";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ExtractSAMLAttributes.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    @Nonnull
    private Function<ProfileRequestContext, SAMLTokenContext> samlTokenContextLookupStrategy = new ChildContextLookup(SAMLTokenContext.class);
    @Nonnull
    private Function<ProfileRequestContext, String> requesterLookupStrategy = new IssuerLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, String> issuerLookupStrategy = new RelyingPartyIdLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, AttributeContext> attributeContextCreationStrategy = new ChildContextLookup(AttributeContext.class, true).compose((Function)new ChildContextLookup(SAMLTokenContext.class));
    @Nullable
    private Function<SAMLTokenContext, Collection<IdPAttribute>> standardExtractionStrategy;
    private boolean acceptUnfilteredAttributes;
    @NonnullBeforeExec
    private SAMLTokenContext samlTokenContext;
    @NonnullBeforeExec
    private BrowserSSOProfileConfiguration profileConfiguration;
    @NonnullBeforeExec
    private AttributeContext attributeContext;

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.checkSetterPreconditions();
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setSAMLTokenContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLTokenContext> strategy) {
        this.checkSetterPreconditions();
        this.samlTokenContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SAMLTokenContext lookup strategy cannot be null");
    }

    public void setRequesterLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.requesterLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Requester lookup strategy cannot be null");
    }

    public void setIssuerLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.issuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Issuer lookup strategy cannot be null");
    }

    public void setAttributeContextCreationStrategy(@Nonnull Function<ProfileRequestContext, AttributeContext> strategy) {
        this.checkSetterPreconditions();
        this.attributeContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeContext creation strategy cannot be null");
    }

    public void setStandardExtractionStrategy(@Nullable Function<SAMLTokenContext, Collection<IdPAttribute>> strategy) {
        this.checkSetterPreconditions();
        this.standardExtractionStrategy = strategy;
    }

    public void setAcceptUnfilteredAttributes(boolean flag) {
        this.checkSetterPreconditions();
        this.acceptUnfilteredAttributes = flag;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.samlTokenContext = this.samlTokenContextLookupStrategy.apply(profileRequestContext);
        if (this.samlTokenContext == null || this.samlTokenContext.getAuthnStatement() == null) {
            this.log.debug("{} No SAMLAuthnContext or AuthnStatement available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return false;
        }
        RelyingPartyContext rpContext = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        if (rpContext == null) {
            this.log.error("{} Unable to locate RelyingPartyContext", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
            return false;
        }
        if (rpContext.getProfileConfig() == null) {
            this.log.error("{} Unable to locate profile configuration", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        if (!(rpContext.getProfileConfig() instanceof BrowserSSOProfileConfiguration)) {
            this.log.error("{} Not a SAML 2 profile configuration", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        this.attributeContext = this.attributeContextCreationStrategy.apply(profileRequestContext);
        if (this.attributeContext == null) {
            this.log.debug("{} Unable to create AttributeContext", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.profileConfiguration = (BrowserSSOProfileConfiguration)rpContext.getProfileConfig();
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        Collection<IdPAttribute> newAttributes;
        Function aes;
        this.processAttributes(profileRequestContext);
        HashMap accumulator = new HashMap();
        accumulator.putAll(this.attributeContext.getIdPAttributes());
        if (this.standardExtractionStrategy != null && this.profileConfiguration.isExtractStandardAttributes(profileRequestContext)) {
            this.log.debug("{} Extracting standard attributes", (Object)this.getLogPrefix());
            assert (this.standardExtractionStrategy != null);
            Collection<IdPAttribute> standards = this.standardExtractionStrategy.apply(this.samlTokenContext);
            if (standards != null && !standards.isEmpty()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("{} Extracted standard attributes: {}", (Object)this.getLogPrefix(), standards.stream().map(IdPAttribute::getId).collect(Collectors.toUnmodifiableList()));
                }
                IdPAttributeSupport.withMapMergeDuplicates(accumulator, standards);
            }
        }
        if ((aes = this.profileConfiguration.getAttributeExtractionStrategy(profileRequestContext)) != null) {
            this.log.debug("{} Applying custom attribute extraction strategy", (Object)this.getLogPrefix());
            newAttributes = (Collection<IdPAttribute>)aes.apply(profileRequestContext);
            if (newAttributes != null && !newAttributes.isEmpty()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("{} Extracted attributes with custom strategy: {}", (Object)this.getLogPrefix(), newAttributes.stream().map(IdPAttribute::getId).collect(Collectors.toUnmodifiableList()));
                }
                IdPAttributeSupport.withMapMergeDuplicates(accumulator, newAttributes);
            }
        }
        if (this.profileConfiguration.isResolveAttributes(profileRequestContext)) {
            this.log.debug("{} Performing internal attribute resolution", (Object)this.getLogPrefix());
            newAttributes = this.resolveAttributes(profileRequestContext);
            if (newAttributes != null && !newAttributes.isEmpty()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("{} Resolved attributes internally: {}", (Object)this.getLogPrefix(), newAttributes.stream().map(IdPAttribute::getId).collect(Collectors.toUnmodifiableList()));
                }
                IdPAttributeSupport.withMapMergeDuplicates(accumulator, newAttributes);
            }
        }
        this.attributeContext.setIdPAttributes(accumulator);
    }

    @Nonnull
    private Response getResponse(@Nonnull ProfileRequestContext profileRequestContext) {
        MessageContext inbound = profileRequestContext.ensureInboundMessageContext();
        return (Response)inbound.ensureMessage();
    }

    private void processAttributes(@Nonnull ProfileRequestContext profileRequestContext) {
        this.log.debug("{} Decoding incoming SAML Attributes and NameID", (Object)this.getLogPrefix());
        HashMultimap mapped = HashMultimap.create();
        assert (mapped != null);
        Subject subject = this.samlTokenContext.getSubject();
        NameID nameID = subject != null ? subject.getNameID() : null;
        AuthnStatement theStatement = this.samlTokenContext.getAuthnStatement();
        assert (theStatement != null);
        try (ServiceableComponent component = this.ensureApplication().getAttributeTranscoderRegistry().getServiceableComponent();){
            if (nameID != null) {
                try {
                    this.decodeNameID((AttributeTranscoderRegistry)component.getComponent(), profileRequestContext, nameID, (Multimap<String, IdPAttribute>)mapped);
                }
                catch (AttributeDecodingException e) {
                    this.log.error("{} Error decoding inbound NameID", (Object)this.getLogPrefix(), (Object)e);
                }
            }
            Response response = this.getResponse(profileRequestContext);
            for (Assertion assertion : response.getAssertions()) {
                for (AttributeStatement statement : assertion.getAttributeStatements()) {
                    for (Attribute designator : statement.getAttributes()) {
                        assert (designator != null);
                        try {
                            this.decodeAttribute((AttributeTranscoderRegistry)component.getComponent(), profileRequestContext, designator, (Multimap<String, IdPAttribute>)mapped);
                        }
                        catch (AttributeDecodingException e) {
                            this.log.error("{} Error decoding inbound Attribute", (Object)this.getLogPrefix(), (Object)e);
                        }
                    }
                }
            }
        }
        catch (ServiceException e) {
            this.log.error("Attribute transcoder service unavailable", (Throwable)e);
            return;
        }
        this.log.debug("{} Incoming SAML Attributes mapped to attribute IDs: {}", (Object)this.getLogPrefix(), (Object)mapped.keySet());
        if (!mapped.isEmpty()) {
            this.attributeContext.setUnfilteredIdPAttributes(IdPAttributeSupport.toMapMergeDuplicates((Collection)mapped.values()));
            this.attributeContext.setIdPAttributes((Map)null);
            this.filterAttributes(profileRequestContext);
        }
    }

    private void decodeAttribute(@Nonnull AttributeTranscoderRegistry registry, @Nonnull ProfileRequestContext profileRequestContext, @Nonnull Attribute input, @Nonnull @Live Multimap<String, IdPAttribute> results) throws AttributeDecodingException {
        Collection transcodingRules = registry.getTranscodingRules((Object)input);
        if (transcodingRules.isEmpty()) {
            this.log.info("{} No transcoding rule for Attribute (Name '{}', NameFormat: '{}')", new Object[]{this.getLogPrefix(), input.getName(), input.getNameFormat() != null ? input.getNameFormat() : "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified"});
            return;
        }
        for (TranscodingRule rules : transcodingRules) {
            assert (rules != null);
            AttributeTranscoder transcoder = TranscoderSupport.getTranscoder((TranscodingRule)rules);
            IdPAttribute decodedAttribute = transcoder.decode(profileRequestContext, (Object)input, rules);
            if (decodedAttribute == null) continue;
            results.put((Object)decodedAttribute.getId(), (Object)decodedAttribute);
        }
    }

    private void decodeNameID(@Nonnull AttributeTranscoderRegistry registry, @Nonnull ProfileRequestContext profileRequestContext, @Nonnull NameID input, @Nonnull @Live Multimap<String, IdPAttribute> results) throws AttributeDecodingException {
        Collection transcodingRules = registry.getTranscodingRules((Object)input);
        if (transcodingRules.isEmpty()) {
            this.log.info("{} No transcoding rule for NameID (Format: '{}')", (Object)this.getLogPrefix(), (Object)(input.getFormat() != null ? input.getFormat() : "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified"));
            return;
        }
        for (TranscodingRule rules : transcodingRules) {
            assert (rules != null);
            AttributeTranscoder transcoder = TranscoderSupport.getTranscoder((TranscodingRule)rules);
            IdPAttribute decodedAttribute = transcoder.decode(profileRequestContext, (Object)input, rules);
            if (decodedAttribute == null) continue;
            results.put((Object)decodedAttribute.getId(), (Object)decodedAttribute);
        }
    }

    private void filterAttributes(@Nonnull ProfileRequestContext profileRequestContext) {
        AttributeFilterContext filterContext = (AttributeFilterContext)this.samlTokenContext.ensureSubcontext(AttributeFilterContext.class);
        this.populateFilterContext(profileRequestContext, filterContext);
        try (ServiceableComponent filterComponent = this.ensureApplication().getAttributeFilter().getServiceableComponent();
             ServiceableComponent metadataResolverComponent = this.ensureApplication().getMetadataResolver().getServiceableComponent();){
            filterContext.setMetadataResolver((MetadataResolver)metadataResolverComponent.getComponent());
            AttributeFilter filter = (AttributeFilter)filterComponent.getComponent();
            filter.filterAttributes(filterContext);
            filterContext.removeFromParent();
            this.attributeContext.setIdPAttributes(filterContext.getFilteredIdPAttributes());
        }
        catch (AttributeFilterException e) {
            this.log.error("{} Error while filtering inbound attributes", (Object)this.getLogPrefix(), (Object)e);
        }
        catch (ServiceException e) {
            this.log.error("{} Invalid AttributeFilter configuration", (Object)this.getLogPrefix(), (Object)e);
        }
    }

    private void populateFilterContext(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AttributeFilterContext filterContext) {
        filterContext.setDirection(AttributeFilterContext.Direction.INBOUND).setPrefilteredIdPAttributes(this.attributeContext.getUnfilteredIdPAttributes()).setRequesterMetadataContextLookupStrategy(null).setIssuerMetadataContextLookupStrategy(new SAMLMetadataContextLookupFunction().compose((Function)new RecursiveTypedParentContextLookup(ProfileRequestContext.class))).setProxiedRequesterContextLookupStrategy(null).setAttributeIssuerID(this.issuerLookupStrategy.apply(profileRequestContext)).setAttributeRecipientID(this.requesterLookupStrategy.apply(profileRequestContext)).setAttributeRecipientGroupID(this.profileConfiguration.getAttributeRecipientGroupID(profileRequestContext)).setIncludeUnfilteredAttributes(this.acceptUnfilteredAttributes);
    }

    @Nullable
    private Collection<IdPAttribute> resolveAttributes(@Nonnull ProfileRequestContext profileRequestContext) {
        AttributeResolutionContext resolutionContext = new AttributeResolutionContext();
        resolutionContext.setResolutionLabel("sp/consumer/saml2").setPrincipal(this.profileConfiguration.getAttributeResolutionPrincipal(profileRequestContext)).setAttributeIssuerID(this.issuerLookupStrategy.apply(profileRequestContext)).setAttributeRecipientID(this.requesterLookupStrategy.apply(profileRequestContext)).setAttributeRecipientGroupID(this.profileConfiguration.getAttributeRecipientGroupID(profileRequestContext)).setRequestedIdPAttributeNames(this.profileConfiguration.getRequestedIdPAttributeNames(profileRequestContext));
        profileRequestContext.addSubcontext((BaseContext)resolutionContext, true);
        resolutionContext.resolveAttributes(this.ensureApplication().getAttributeResolver());
        return resolutionContext.getResolvedIdPAttributes().values();
    }

    public static class StandardExtractionStrategy
    implements Function<SAMLTokenContext, Collection<IdPAttribute>> {
        @Nullable
        private String issuerAttributeId;
        @Nullable
        private String authnInstantAttributeId;
        @Nullable
        private String authnContextClassRefAttributeId;
        @Nullable
        private String authnContextDeclRefAttributeId;
        @Nullable
        private String sessionIndexAttributeId;
        @Nullable
        private String consentAttributeId;
        @Nullable
        private String authorityAttributeId;
        @Nullable
        private String notBeforeAttributeId;
        @Nullable
        private String notOnOrAfterAttributeId;
        @Nullable
        private String sessionNotOnOrAfterAttributeId;
        @Nullable
        private String addressAttributeId;
        @Nullable
        private String dnsNameAttributeId;

        public void setIssuerAttributeId(@Nullable String id) {
            this.issuerAttributeId = StringSupport.trimOrNull((String)id);
        }

        public void setAuthnInstantAttributeId(@Nullable String id) {
            this.authnInstantAttributeId = StringSupport.trimOrNull((String)id);
        }

        public void setAuthnContextClassRefAttributeId(@Nullable String id) {
            this.authnContextClassRefAttributeId = StringSupport.trimOrNull((String)id);
        }

        public void setAuthnContextDeclRefAttributeId(@Nullable String id) {
            this.authnContextDeclRefAttributeId = StringSupport.trimOrNull((String)id);
        }

        public void setSessionIndexAttributeId(@Nullable String id) {
            this.sessionIndexAttributeId = StringSupport.trimOrNull((String)id);
        }

        public void setConsentAttributeId(@Nullable String id) {
            this.consentAttributeId = StringSupport.trimOrNull((String)id);
        }

        public void setAuthenticatingAuthorityAttributeId(@Nullable String id) {
            this.authorityAttributeId = StringSupport.trimOrNull((String)id);
        }

        public void setNotBeforeAttributeId(@Nullable String id) {
            this.notBeforeAttributeId = StringSupport.trimOrNull((String)id);
        }

        public void setNotOnOrAfterAttributeId(@Nullable String id) {
            this.notOnOrAfterAttributeId = StringSupport.trimOrNull((String)id);
        }

        public void setSessionNotOnOrAfterAttributeId(@Nullable String id) {
            this.sessionNotOnOrAfterAttributeId = StringSupport.trimOrNull((String)id);
        }

        public void setAddressAttributeId(@Nullable String id) {
            this.addressAttributeId = StringSupport.trimOrNull((String)id);
        }

        public void setDNSNameAttributeId(@Nullable String id) {
            this.dnsNameAttributeId = StringSupport.trimOrNull((String)id);
        }

        @Override
        @Nullable
        public Collection<IdPAttribute> apply(@Nullable SAMLTokenContext samlTokenContext) {
            IdPAttribute attr;
            String s;
            Instant ts;
            StatusResponseType srt;
            IdPAttribute attr2;
            String s2;
            IdPAttribute attr3;
            Instant ts2;
            IdPAttribute attr4;
            String s3;
            AuthnStatement statement;
            AuthnStatement authnStatement = statement = samlTokenContext != null ? samlTokenContext.getAuthnStatement() : null;
            if (statement == null) {
                return null;
            }
            Assertion assertion = (Assertion)statement.getParent();
            assert (assertion != null);
            ArrayList<IdPAttribute> attributes = new ArrayList<IdPAttribute>();
            if (this.issuerAttributeId != null) {
                Issuer issuer = assertion.getIssuer();
                String string = s3 = issuer != null ? issuer.getValue() : null;
                if (s3 != null) {
                    assert (this.issuerAttributeId != null);
                    attr4 = new IdPAttribute(this.issuerAttributeId);
                    attr4.setValues(CollectionSupport.singletonList((Object)new StringAttributeValue(s3)));
                    attributes.add(attr4);
                }
            }
            if (this.authnInstantAttributeId != null && (ts2 = statement.getAuthnInstant()) != null) {
                assert (this.authnInstantAttributeId != null);
                attr3 = new IdPAttribute(this.authnInstantAttributeId);
                attr3.setValues(CollectionSupport.singletonList((Object)new DateTimeAttributeValue(ts2)));
                attributes.add(attr3);
            }
            AuthnContext ac = statement.getAuthnContext();
            if (this.authnContextClassRefAttributeId != null && ac != null) {
                AuthnContextClassRef classRef = ac.getAuthnContextClassRef();
                String string = s2 = classRef != null ? classRef.getURI() : null;
                if (s2 != null) {
                    assert (this.authnContextClassRefAttributeId != null);
                    attr2 = new IdPAttribute(this.authnContextClassRefAttributeId);
                    attr2.setValues(CollectionSupport.singletonList((Object)new StringAttributeValue(s2)));
                    attributes.add(attr2);
                }
            }
            if (this.authnContextDeclRefAttributeId != null && ac != null) {
                AuthnContextDeclRef declRef = ac.getAuthnContextDeclRef();
                String string = s2 = declRef != null ? declRef.getURI() : null;
                if (s2 != null) {
                    assert (this.authnContextDeclRefAttributeId != null);
                    attr2 = new IdPAttribute(this.authnContextDeclRefAttributeId);
                    attr2.setValues(CollectionSupport.singletonList((Object)new StringAttributeValue(s2)));
                    attributes.add(attr2);
                }
            }
            if (this.sessionIndexAttributeId != null && (s3 = statement.getSessionIndex()) != null) {
                assert (this.sessionIndexAttributeId != null);
                attr4 = new IdPAttribute(this.sessionIndexAttributeId);
                attr4.setValues(CollectionSupport.singletonList((Object)new StringAttributeValue(s3)));
                attributes.add(attr4);
            }
            if (this.consentAttributeId != null && (attr4 = assertion.getParent()) instanceof StatusResponseType && (s2 = (srt = (StatusResponseType)attr4).getConsent()) != null) {
                assert (this.consentAttributeId != null);
                attr2 = new IdPAttribute(this.consentAttributeId);
                attr2.setValues(CollectionSupport.singletonList((Object)new StringAttributeValue(s2)));
                attributes.add(attr2);
            }
            if (this.authorityAttributeId != null && ac != null && !ac.getAuthenticatingAuthorities().isEmpty()) {
                assert (this.authorityAttributeId != null);
                attr3 = new IdPAttribute(this.authorityAttributeId);
                attr3.setValues((List)((NonnullSupplier)ac.getAuthenticatingAuthorities().stream().map(XSURI::getURI).map(StringAttributeValue::new).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableList()))).get());
                attributes.add(attr3);
            }
            Conditions conditions = assertion.getConditions();
            if (this.notBeforeAttributeId != null && conditions != null && (ts = conditions.getNotBefore()) != null) {
                assert (this.notBeforeAttributeId != null);
                attr2 = new IdPAttribute(this.notBeforeAttributeId);
                attr2.setValues(CollectionSupport.singletonList((Object)new DateTimeAttributeValue(ts)));
                attributes.add(attr2);
            }
            if (this.notOnOrAfterAttributeId != null && conditions != null && (ts = conditions.getNotOnOrAfter()) != null) {
                assert (this.notOnOrAfterAttributeId != null);
                attr2 = new IdPAttribute(this.notOnOrAfterAttributeId);
                attr2.setValues(CollectionSupport.singletonList((Object)new DateTimeAttributeValue(ts)));
                attributes.add(attr2);
            }
            if (this.sessionNotOnOrAfterAttributeId != null && (ts = statement.getSessionNotOnOrAfter()) != null) {
                assert (this.sessionNotOnOrAfterAttributeId != null);
                attr2 = new IdPAttribute(this.sessionNotOnOrAfterAttributeId);
                attr2.setValues(CollectionSupport.singletonList((Object)new DateTimeAttributeValue(ts)));
                attributes.add(attr2);
            }
            SubjectLocality locality = statement.getSubjectLocality();
            if (this.addressAttributeId != null && locality != null && (s = locality.getAddress()) != null) {
                assert (this.addressAttributeId != null);
                attr = new IdPAttribute(this.addressAttributeId);
                attr.setValues(CollectionSupport.singletonList((Object)new StringAttributeValue(s)));
                attributes.add(attr);
            }
            if (this.dnsNameAttributeId != null && locality != null && (s = locality.getDNSName()) != null) {
                assert (this.dnsNameAttributeId != null);
                attr = new IdPAttribute(this.dnsNameAttributeId);
                attr.setValues(CollectionSupport.singletonList((Object)new StringAttributeValue(s)));
                attributes.add(attr);
            }
            return attributes;
        }
    }
}

