/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.saml.saml2.profile.config.impl;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.sp.saml.saml2.profile.config.impl.AbstractSAML2ArtifactConsumerProfileConfiguration;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.logic.NoIntegrityMessageChannelPredicate;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.logic.NoConfidentialityMessageChannelPredicate;

public class SingleLogoutProfileConfiguration
extends AbstractSAML2ArtifactConsumerProfileConfiguration
implements net.shibboleth.sp.saml.saml2.profile.config.SingleLogoutProfileConfiguration {
    @Nonnull
    private Predicate<MessageContext> signSOAPRequestsPredicate;
    @Nonnull
    private Predicate<MessageContext> clientTLSSOAPRequestsPredicate;
    @Nonnull
    private Predicate<ProfileRequestContext> asynchronousPredicate;
    @Nonnull
    private Function<ProfileRequestContext, Collection<String>> qualifiedNameIDFormatsLookupStrategy;

    public SingleLogoutProfileConfiguration() {
        this("http://shibboleth.net/ns/profiles/saml2/logout");
    }

    protected SingleLogoutProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
        this.setSignRequestsPredicate((Predicate<ProfileRequestContext>)new org.opensaml.profile.logic.NoIntegrityMessageChannelPredicate());
        this.setSignResponsesPredicate((Predicate<ProfileRequestContext>)new org.opensaml.profile.logic.NoIntegrityMessageChannelPredicate());
        this.setEncryptNameIDsPredicate((Predicate<ProfileRequestContext>)new NoConfidentialityMessageChannelPredicate());
        this.signSOAPRequestsPredicate = new NoIntegrityMessageChannelPredicate();
        this.clientTLSSOAPRequestsPredicate = new NoIntegrityMessageChannelPredicate().negate();
        this.asynchronousPredicate = PredicateSupport.alwaysTrue();
        this.qualifiedNameIDFormatsLookupStrategy = FunctionSupport.constant(null);
    }

    public boolean isSignSOAPRequests(@Nullable MessageContext messageContext) {
        return this.signSOAPRequestsPredicate.test(messageContext);
    }

    public void setSignSOAPRequests(boolean flag) {
        this.signSOAPRequestsPredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setSignSOAPRequestsPredicate(@Nonnull Predicate<MessageContext> predicate) {
        this.signSOAPRequestsPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Predicate used to determine SOAP-based signing cannot be null");
    }

    public boolean isClientTLSSOAPRequests(@Nullable MessageContext messageContext) {
        return this.clientTLSSOAPRequestsPredicate.test(messageContext);
    }

    public void setClientTLSSOAPRequests(boolean flag) {
        this.clientTLSSOAPRequestsPredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setClientTLSSOAPRequestsPredicate(@Nonnull Predicate<MessageContext> predicate) {
        this.clientTLSSOAPRequestsPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Predicate used to determine SOAP-based client TLS use cannot be null");
    }

    public boolean isAsynchronous(@Nullable ProfileRequestContext profileRequestContext) {
        return this.asynchronousPredicate.test(profileRequestContext);
    }

    public void setAsynchronous(boolean flag) {
        this.asynchronousPredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setAsynchronousPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.asynchronousPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    @Nonnull
    @NonnullElements
    @NotLive
    public Collection<String> getQualifiedNameIDFormats(@Nullable ProfileRequestContext profileRequestContext) {
        Collection<String> formats = this.qualifiedNameIDFormatsLookupStrategy.apply(profileRequestContext);
        if (formats != null) {
            return CollectionSupport.copyToList(formats);
        }
        return CollectionSupport.emptyList();
    }

    public void setQualifiedNameIDFormats(@Nullable @NonnullElements Collection<String> formats) {
        this.qualifiedNameIDFormatsLookupStrategy = formats == null || formats.isEmpty() ? FunctionSupport.constant(null) : FunctionSupport.constant(List.copyOf(StringSupport.normalizeStringCollection(formats)));
    }

    public void setQualifiedNameIDFormatsLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<String>> strategy) {
        this.qualifiedNameIDFormatsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }
}

