/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.saml.saml2.profile.config.impl;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.saml.profile.config.SAMLArtifactConsumerProfileConfiguration;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.sp.saml.saml2.profile.config.impl.AbstractSAML2ProfileConfiguration;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.logic.NoIntegrityMessageChannelPredicate;

public abstract class AbstractSAML2ArtifactConsumerProfileConfiguration
extends AbstractSAML2ProfileConfiguration
implements SAMLArtifactConsumerProfileConfiguration {
    @Nonnull
    private Predicate<MessageContext> signArtifactRequestsPredicate = new NoIntegrityMessageChannelPredicate();
    @Nonnull
    private Predicate<MessageContext> clientTLSArtifactRequestsPredicate = new NoIntegrityMessageChannelPredicate().negate();

    protected AbstractSAML2ArtifactConsumerProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
    }

    public boolean isSignArtifactRequests(@Nullable MessageContext messageContext) {
        return this.signArtifactRequestsPredicate.test(messageContext);
    }

    public void setSignArtifactRequests(boolean flag) {
        this.signArtifactRequestsPredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setSignArtifactRequestsPredicate(@Nonnull Predicate<MessageContext> predicate) {
        this.signArtifactRequestsPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Predicate used to determine artifact request signing may not be null");
    }

    public boolean isClientTLSArtifactRequests(@Nullable MessageContext messageContext) {
        return this.clientTLSArtifactRequestsPredicate.test(messageContext);
    }

    public void setClientTLSArtifactRequests(boolean flag) {
        this.clientTLSArtifactRequestsPredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setClientTLSArtifactRequestsPredicate(@Nonnull Predicate<MessageContext> predicate) {
        this.clientTLSArtifactRequestsPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Predicate used to determine artifact client TLS use may not be null");
    }
}

