/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.saml.saml2.profile.impl;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.config.navigate.IdentifierGenerationStrategyLookupFunction;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.context.navigate.IssuerLookupFunction;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import net.shibboleth.sp.ddf.DDF;
import net.shibboleth.sp.profile.AbstractApplicationAction;
import net.shibboleth.sp.saml.saml2.profile.config.BrowserSSOProfileConfiguration;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.ext.reqattr.RequestedAttributes;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Extensions;
import org.opensaml.saml.saml2.core.IDPEntry;
import org.opensaml.saml.saml2.core.IDPList;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml.saml2.core.Scoping;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.metadata.RequestedAttribute;
import org.slf4j.Logger;

public class AddAuthnRequest
extends AbstractApplicationAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AddAuthnRequest.class);
    private boolean overwriteExisting;
    private boolean includeScoping;
    @Nullable
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, IdentifierGenerationStrategy> idGeneratorLookupStrategy = new IdentifierGenerationStrategyLookupFunction();
    @Nullable
    private Function<ProfileRequestContext, String> issuerLookupStrategy = new IssuerLookupFunction();
    @Nullable
    private Function<ProfileRequestContext, NameID> nameIDLookupStrategy;
    @Nonnull
    private Map<String, String> inboundBindingMap;
    @NonnullBeforeExec
    private IdentifierGenerationStrategy idGenerator;
    @NonnullBeforeExec
    private BrowserSSOProfileConfiguration profileConfiguration;
    @NonnullBeforeExec
    private DDF input;
    @Nullable
    private String issuerId;

    public AddAuthnRequest() {
        this.relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
        this.inboundBindingMap = CollectionSupport.emptyMap();
    }

    public void setOverwriteExisting(boolean flag) {
        this.checkSetterPreconditions();
        this.overwriteExisting = flag;
    }

    public void setIncludeScoping(boolean flag) {
        this.checkSetterPreconditions();
        this.includeScoping = true;
    }

    public void setRelyingPartyContextLookupStrategy(@Nullable Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.checkSetterPreconditions();
        this.relyingPartyContextLookupStrategy = strategy;
    }

    public void setIdentifierGeneratorLookupStrategy(@Nonnull Function<ProfileRequestContext, IdentifierGenerationStrategy> strategy) {
        this.checkSetterPreconditions();
        this.idGeneratorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"IdentifierGenerationStrategy lookup strategy cannot be null");
    }

    public void setIssuerLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.issuerLookupStrategy = strategy;
    }

    public void setNameIDLookupStrategy(@Nullable Function<ProfileRequestContext, NameID> strategy) {
        this.checkSetterPreconditions();
        this.nameIDLookupStrategy = strategy;
    }

    public void setInboundBindingMap(@Nullable Map<String, String> map) {
        this.checkSetterPreconditions();
        this.inboundBindingMap = map != null ? CollectionSupport.copyToMap(map) : CollectionSupport.emptyMap();
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ProfileConfiguration profileConfiguration;
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.input = this.ensureAgentRequestContext().getInput();
        if (this.input == null) {
            this.log.error("{} No input message", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return false;
        }
        RelyingPartyContext rpCtx = (RelyingPartyContext)profileRequestContext.getSubcontext(RelyingPartyContext.class);
        if (rpCtx != null && (profileConfiguration = rpCtx.getProfileConfig()) instanceof BrowserSSOProfileConfiguration) {
            BrowserSSOProfileConfiguration sso;
            this.profileConfiguration = sso = (BrowserSSOProfileConfiguration)profileConfiguration;
        }
        if (this.profileConfiguration == null) {
            this.log.error("{} BrowserSSOProfileConfiguration not found", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        MessageContext outboundMessageCtx = profileRequestContext.getOutboundMessageContext();
        if (outboundMessageCtx == null) {
            this.log.debug("{} No outbound message context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        if (!this.overwriteExisting && outboundMessageCtx.getMessage() != null) {
            this.log.debug("{} Outbound message context already contains a message", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.idGenerator = this.idGeneratorLookupStrategy.apply(profileRequestContext);
        if (this.idGenerator == null) {
            this.log.debug("{} No identifier generation strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        if (this.issuerLookupStrategy != null) {
            this.issuerId = this.issuerLookupStrategy.apply(profileRequestContext);
        }
        outboundMessageCtx.setMessage(null);
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        XMLObjectBuilderFactory bf = XMLObjectProviderRegistrySupport.getBuilderFactory();
        SAMLObjectBuilder requestBuilder = (SAMLObjectBuilder)bf.ensureBuilder(AuthnRequest.DEFAULT_ELEMENT_NAME);
        SAMLObjectBuilder nipBuilder = (SAMLObjectBuilder)bf.ensureBuilder(NameIDPolicy.DEFAULT_ELEMENT_NAME);
        AuthnRequest object = (AuthnRequest)requestBuilder.buildObject();
        object.setID(this.idGenerator.generateIdentifier());
        object.setIssueInstant(Instant.now());
        object.setVersion(SAMLVersion.VERSION_20);
        if (!this.setResponseEndpoint(profileRequestContext, object)) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
        this.log.debug("{} Response endpoint ({}), binding ({})", new Object[]{this.getLogPrefix(), object.getAssertionConsumerServiceURL(), object.getProtocolBinding()});
        if (this.issuerId != null) {
            this.log.debug("{} Setting Issuer to {}", (Object)this.getLogPrefix(), (Object)this.issuerId);
            SAMLObjectBuilder issuerBuilder = (SAMLObjectBuilder)bf.ensureBuilder(Issuer.DEFAULT_ELEMENT_NAME);
            Issuer issuer = (Issuer)issuerBuilder.buildObject();
            issuer.setValue(this.issuerId);
            object.setIssuer(issuer);
        } else {
            this.log.debug("{} No issuer value available, leaving Issuer unset", (Object)this.getLogPrefix());
        }
        Integer index = this.input.getmember("attributeIndex").integer();
        if (index == null) {
            index = this.profileConfiguration.getAttributeIndex(profileRequestContext);
        }
        if (index != null) {
            this.log.debug("{} Setting AttributeConsumingServiceIndex to '{}'", (Object)this.getLogPrefix(), (Object)index);
            object.setAttributeConsumingServiceIndex(index);
        }
        this.setForceAuthn(profileRequestContext, object);
        Integer passive = this.input.getmember("isPassive").integer();
        if (passive != null && passive == 1) {
            this.log.debug("{} Setting IsPassive to true", (Object)this.getLogPrefix());
            object.setIsPassive(Boolean.valueOf(true));
        }
        object.setNameIDPolicy(this.buildNameIDPolicy(profileRequestContext, (SAMLObjectBuilder<NameIDPolicy>)nipBuilder));
        object.setRequestedAuthnContext(this.buildRequestedAuthnContext(profileRequestContext));
        object.setSubject(this.buildSubject(profileRequestContext));
        object.setExtensions(this.buildExtensions(profileRequestContext));
        if (this.includeScoping) {
            object.setScoping(this.buildScoping(profileRequestContext));
        }
        profileRequestContext.ensureOutboundMessageContext().setMessage((Object)object);
        String relayState = this.input.getmember("state").string();
        if (relayState != null) {
            SAMLBindingSupport.setRelayState((MessageContext)profileRequestContext.ensureOutboundMessageContext(), (String)relayState);
        }
        this.log.info("{} Generated AuthnRequest with ID {} from {}", new Object[]{this.getLogPrefix(), object.getID(), this.issuerId});
    }

    private boolean setResponseEndpoint(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthnRequest authnRequest) {
        DDF response_url = this.input.getmember("response_url");
        if (response_url.isstring()) {
            authnRequest.setAssertionConsumerServiceURL(response_url.string());
            authnRequest.setProtocolBinding(this.profileConfiguration.getResponseBinding(profileRequestContext));
            return true;
        }
        List endpoints = response_url.asList();
        if (endpoints.isEmpty()) {
            authnRequest.setProtocolBinding(this.profileConfiguration.getResponseBinding(profileRequestContext));
            return true;
        }
        String binding = this.profileConfiguration.getResponseBinding(profileRequestContext);
        if (binding == null) {
            authnRequest.setAssertionConsumerServiceURL(((DDF)endpoints.get(0)).string());
            return true;
        }
        Optional<DDF> match = endpoints.stream().filter(e -> binding.equals(this.inboundBindingMap.get(e.name()))).findFirst();
        if (match.isPresent()) {
            authnRequest.setAssertionConsumerServiceURL(match.get().string());
            authnRequest.setProtocolBinding(this.inboundBindingMap.get(match.get().name()));
            return true;
        }
        this.log.warn("{} No response endpoint supplied matching binding ({})", (Object)this.getLogPrefix(), (Object)binding);
        return false;
    }

    private void setForceAuthn(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthnRequest authnRequest) {
        Integer forceAuthn = this.input.getmember("forceAuthn").integer();
        if (forceAuthn != null) {
            if (this.profileConfiguration.isFeatureDisallowed(profileRequestContext, 16)) {
                this.log.warn("{} Agent disallowed from overriding ForceAuthn", (Object)this.getLogPrefix());
            } else if (forceAuthn == 1) {
                this.log.debug("{} Setting ForceAuthn to true", (Object)this.getLogPrefix());
                authnRequest.setForceAuthn(Boolean.valueOf(true));
                return;
            }
        }
        if (this.profileConfiguration.isForceAuthn(profileRequestContext)) {
            this.log.debug("{} Setting ForceAuthn to true", (Object)this.getLogPrefix());
            authnRequest.setForceAuthn(Boolean.valueOf(true));
        }
    }

    @Nonnull
    NameIDPolicy buildNameIDPolicy(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull SAMLObjectBuilder<NameIDPolicy> builder) {
        String qualifier;
        NameIDPolicy nip = (NameIDPolicy)builder.buildObject();
        nip.setAllowCreate(Boolean.valueOf(true));
        String format = this.input.getmember("NameIDFormat").string();
        if (format != null && this.profileConfiguration.isFeatureDisallowed(profileRequestContext, 4)) {
            this.log.warn("{} Agent disallowed from overriding NameIDPolicy Format", (Object)this.getLogPrefix());
            format = null;
        }
        if (format == null) {
            format = this.profileConfiguration.getNameIDFormat(profileRequestContext);
        }
        if (format != null) {
            this.log.debug("{} Setting NameIDPolicy Format to '{}'", (Object)this.getLogPrefix(), (Object)format);
            nip.setFormat(format);
        }
        if ((qualifier = this.input.getmember("SPNameQualifier").string()) != null) {
            if (this.profileConfiguration.isFeatureDisallowed(profileRequestContext, 8)) {
                this.log.warn("{} Agent disallowed from overriding NameIDPolicy SPNameQualifier", (Object)this.getLogPrefix());
            }
            qualifier = null;
        }
        if (qualifier == null) {
            qualifier = this.profileConfiguration.getSPNameQualifier(profileRequestContext);
        }
        if (qualifier != null) {
            this.log.debug("{} Setting NameIDPolicy SPNameQualifier to '{}'", (Object)this.getLogPrefix(), (Object)qualifier);
            nip.setSPNameQualifier(qualifier);
        }
        return nip;
    }

    @Nullable
    private RequestedAuthnContext buildRequestedAuthnContext(@Nullable ProfileRequestContext profileRequestContext) {
        AuthnContextComparisonTypeEnumeration operator;
        List classrefs = (List)((NonnullSupplier)this.input.getmember("AuthnContextClassRef").asList().stream().map(DDF::string).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableList()))).get();
        if (!classrefs.isEmpty() && this.profileConfiguration.isFeatureDisallowed(profileRequestContext, 1)) {
            this.log.warn("{} Agent disallowed from overriding RequestedAuthnContext", (Object)this.getLogPrefix());
            classrefs = CollectionSupport.emptyList();
        }
        if (classrefs.isEmpty()) {
            this.profileConfiguration.getAuthnContextClassRefs(profileRequestContext);
        }
        if (classrefs.isEmpty()) {
            return null;
        }
        this.log.debug("{} Setting requested AuthnContextClassRef(s) {}", (Object)this.getLogPrefix(), (Object)classrefs);
        XMLObjectBuilderFactory bf = XMLObjectProviderRegistrySupport.getBuilderFactory();
        SAMLObjectBuilder builder = (SAMLObjectBuilder)bf.ensureBuilder(RequestedAuthnContext.DEFAULT_ELEMENT_NAME);
        SAMLObjectBuilder acBuilder = (SAMLObjectBuilder)bf.ensureBuilder(AuthnContextClassRef.DEFAULT_ELEMENT_NAME);
        RequestedAuthnContext rac = (RequestedAuthnContext)builder.buildObject();
        classrefs.forEach(ref -> {
            AuthnContextClassRef obj = (AuthnContextClassRef)acBuilder.buildObject();
            obj.setURI(ref);
            rac.getAuthnContextClassRefs().add(obj);
        });
        String opstring = this.input.getmember("authnContextComparison").string();
        if (opstring != null && this.profileConfiguration.isFeatureDisallowed(profileRequestContext, 1)) {
            this.log.warn("{} Agent disallowed from overriding RequestedAuthnContext operator", (Object)this.getLogPrefix());
            opstring = null;
        }
        if (opstring != null) {
            try {
                operator = AuthnContextComparisonTypeEnumeration.valueOf((String)opstring.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.log.warn("{} Error translating RequestedAuthnContext operator string", (Object)this.getLogPrefix(), (Object)e);
                return null;
            }
        } else {
            operator = this.profileConfiguration.getAuthnContextComparison(profileRequestContext);
        }
        if (operator != null) {
            this.log.debug("{} Setting RequestedAuthnContext operator to {}", (Object)this.getLogPrefix(), (Object)operator);
            rac.setComparison(operator);
        }
        return rac;
    }

    @Nullable
    private Subject buildSubject(@Nonnull ProfileRequestContext profileRequestContext) {
        NameID nameID;
        NameID nameID2 = nameID = this.nameIDLookupStrategy != null ? this.nameIDLookupStrategy.apply(profileRequestContext) : null;
        if (nameID == null) {
            return null;
        }
        XMLObjectBuilderFactory bf = XMLObjectProviderRegistrySupport.getBuilderFactory();
        SAMLObjectBuilder subjectBuilder = (SAMLObjectBuilder)bf.ensureBuilder(Subject.DEFAULT_ELEMENT_NAME);
        Subject subject = (Subject)subjectBuilder.buildObject();
        subject.setNameID(nameID);
        this.log.debug("{} Populating request with NameID '{}' and Format '{}'", new Object[]{this.getLogPrefix(), nameID.getValue(), nameID.getFormat()});
        return subject;
    }

    @Nullable
    private Scoping buildScoping(@Nonnull ProfileRequestContext profileRequestContext) {
        String entityID;
        RelyingPartyContext rpContext = this.relyingPartyContextLookupStrategy != null ? this.relyingPartyContextLookupStrategy.apply(profileRequestContext) : null;
        String string = entityID = rpContext != null ? rpContext.getRelyingPartyId() : null;
        if (entityID == null) {
            return null;
        }
        XMLObjectBuilderFactory bf = XMLObjectProviderRegistrySupport.getBuilderFactory();
        SAMLObjectBuilder scopingBuilder = (SAMLObjectBuilder)bf.ensureBuilder(Scoping.DEFAULT_ELEMENT_NAME);
        SAMLObjectBuilder idpListBuilder = (SAMLObjectBuilder)bf.ensureBuilder(IDPList.DEFAULT_ELEMENT_NAME);
        SAMLObjectBuilder idpBuilder = (SAMLObjectBuilder)bf.ensureBuilder(IDPEntry.DEFAULT_ELEMENT_NAME);
        IDPEntry entry = (IDPEntry)idpBuilder.buildObject();
        entry.setProviderID(entityID);
        IDPList idps = (IDPList)idpListBuilder.buildObject();
        idps.getIDPEntrys().add(entry);
        Scoping scoping = (Scoping)scopingBuilder.buildObject();
        scoping.setIDPList(idps);
        return scoping;
    }

    @Nullable
    private Extensions buildExtensions(@Nonnull ProfileRequestContext profileRequestContext) {
        assert (this.profileConfiguration != null);
        Collection attrs = this.profileConfiguration.getRequestedAttributes(profileRequestContext);
        if (!attrs.isEmpty()) {
            XMLObjectBuilderFactory bf = XMLObjectProviderRegistrySupport.getBuilderFactory();
            SAMLObjectBuilder extBuilder = (SAMLObjectBuilder)bf.ensureBuilder(Extensions.DEFAULT_ELEMENT_NAME);
            SAMLObjectBuilder reqExtBuilder = (SAMLObjectBuilder)bf.ensureBuilder(RequestedAttributes.DEFAULT_ELEMENT_NAME);
            RequestedAttributes reqExt = (RequestedAttributes)reqExtBuilder.buildObject();
            attrs.forEach(attr -> {
                try {
                    assert (attr != null);
                    reqExt.getRequestedAttributes().add((RequestedAttribute)XMLObjectSupport.cloneXMLObject((XMLObject)attr));
                }
                catch (MarshallingException | UnmarshallingException e) {
                    this.log.error("{} Error cloning RequestedAttribute from profile configuration", (Object)this.getLogPrefix(), (Object)e);
                }
            });
            Extensions ext = (Extensions)extBuilder.buildObject();
            ext.getUnknownXMLObjects().add(reqExt);
            return ext;
        }
        return null;
    }
}

