/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.saml.saml2.profile.config.impl;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.saml.profile.config.SAMLArtifactConsumerProfileConfiguration;
import net.shibboleth.shared.annotation.constraint.NonNegative;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.sp.saml.saml2.profile.config.impl.AbstractSAML2AssertionConsumerProfileConfiguration;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml.saml2.metadata.RequestedAttribute;

public class BrowserSSOProfileConfiguration
extends AbstractSAML2AssertionConsumerProfileConfiguration
implements SAMLArtifactConsumerProfileConfiguration,
net.shibboleth.sp.saml.saml2.profile.config.BrowserSSOProfileConfiguration {
    @Nonnull
    private Predicate<ProfileRequestContext> resolveAttributesPredicate;
    @Nonnull
    private Function<ProfileRequestContext, Collection<String>> requestedIdPAttributeNamesLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, String> attributeRecipientGroupIDLookupStrategy;
    @Nonnull
    private Predicate<ProfileRequestContext> forceAuthnPredicate;
    @Nonnull
    private Predicate<ProfileRequestContext> checkAddressPredicate;
    @Nonnull
    private Predicate<ProfileRequestContext> checkInResponseToPredicate;
    @Nonnull
    private Predicate<ProfileRequestContext> allowUnsolicitedPredicate;
    @Nonnull
    private Function<ProfileRequestContext, Duration> maximumTimeSinceAuthnLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Integer> proxyCountLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, String> authnContextComparisonLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Collection<String>> authnContextClassRefLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, String> nameIDFormatLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, String> nameQualifierLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Integer> attributeIndexLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Collection<RequestedAttribute>> requestedAttributesLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, String> responseBindingLookupStrategy;
    @Nonnull
    private Predicate<ProfileRequestContext> extractStandardAttributesPredicate;
    @Nonnull
    Function<ProfileRequestContext, Function<ProfileRequestContext, Collection<IdPAttribute>>> attributeExtractionStrategyLookupStrategy;
    @Nonnull
    Function<ProfileRequestContext, String> attributeResolutionPrincipalLookupStrategy;

    public BrowserSSOProfileConfiguration() {
        this("http://shibboleth.net/ns/profiles/saml2/sso/browser");
    }

    protected BrowserSSOProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
        this.setEncryptNameIDs(true);
        this.resolveAttributesPredicate = PredicateSupport.alwaysFalse();
        this.requestedIdPAttributeNamesLookupStrategy = FunctionSupport.constant(null);
        this.attributeRecipientGroupIDLookupStrategy = FunctionSupport.constant(null);
        this.forceAuthnPredicate = PredicateSupport.alwaysFalse();
        this.checkAddressPredicate = PredicateSupport.alwaysTrue();
        this.checkInResponseToPredicate = PredicateSupport.alwaysTrue();
        this.allowUnsolicitedPredicate = PredicateSupport.alwaysTrue();
        this.maximumTimeSinceAuthnLookupStrategy = FunctionSupport.constant(null);
        this.proxyCountLookupStrategy = FunctionSupport.constant(null);
        this.authnContextComparisonLookupStrategy = FunctionSupport.constant(null);
        this.authnContextClassRefLookupStrategy = FunctionSupport.constant(null);
        this.nameIDFormatLookupStrategy = FunctionSupport.constant(null);
        this.nameQualifierLookupStrategy = FunctionSupport.constant(null);
        this.attributeIndexLookupStrategy = FunctionSupport.constant(null);
        this.requestedAttributesLookupStrategy = FunctionSupport.constant(null);
        this.responseBindingLookupStrategy = FunctionSupport.constant((Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        this.extractStandardAttributesPredicate = PredicateSupport.alwaysTrue();
        this.attributeExtractionStrategyLookupStrategy = FunctionSupport.constant(null);
        this.attributeResolutionPrincipalLookupStrategy = FunctionSupport.constant(null);
    }

    public boolean isResolveAttributes(@Nullable ProfileRequestContext profileRequestContext) {
        return this.resolveAttributesPredicate.test(profileRequestContext);
    }

    public void setResolveAttributes(boolean flag) {
        this.resolveAttributesPredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setResolveAttributesPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.resolveAttributesPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Resolve attributes predicate cannot be null");
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Collection<String> getRequestedIdPAttributeNames(@Nullable ProfileRequestContext profileRequestContext) {
        Collection<String> names = this.requestedIdPAttributeNamesLookupStrategy.apply(profileRequestContext);
        if (names != null) {
            return CollectionSupport.copyToSet(names);
        }
        return CollectionSupport.emptySet();
    }

    public void setRequestedIdPAttributeNames(@Nullable Collection<String> names) {
        this.requestedIdPAttributeNamesLookupStrategy = names == null || names.isEmpty() ? FunctionSupport.constant(null) : FunctionSupport.constant((Object)CollectionSupport.copyToSet((Collection)StringSupport.normalizeStringCollection(names)));
    }

    public void setRequestedIdPAttributeNamesLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<String>> strategy) {
        this.requestedIdPAttributeNamesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Requested IdPAttribute names lookup strategy cannot be null");
    }

    @Nullable
    public String getAttributeRecipientGroupID(@Nullable ProfileRequestContext profileRequestContext) {
        return this.attributeRecipientGroupIDLookupStrategy.apply(profileRequestContext);
    }

    public void setAttributeRecipientGroupID(@Nullable String groupID) {
        this.attributeRecipientGroupIDLookupStrategy = FunctionSupport.constant((Object)groupID);
    }

    public void setAttributeRecipientGroupIDLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.attributeRecipientGroupIDLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Group ID lookup strategy cannot be null");
    }

    public boolean isForceAuthn(@Nullable ProfileRequestContext profileRequestContext) {
        return this.forceAuthnPredicate.test(profileRequestContext);
    }

    public void setForceAuthn(boolean flag) {
        this.forceAuthnPredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setForceAuthnPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.forceAuthnPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Forced authentication predicate cannot be null");
    }

    public boolean isCheckAddress(@Nullable ProfileRequestContext profileRequestContext) {
        return this.checkAddressPredicate.test(profileRequestContext);
    }

    public void setCheckAddress(boolean flag) {
        this.checkAddressPredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setCheckAddressPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.checkAddressPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Address checking predicate cannot be null");
    }

    public boolean isCheckInResponseTo(@Nullable ProfileRequestContext profileRequestContext) {
        return this.checkInResponseToPredicate.test(profileRequestContext);
    }

    public void setCheckInResponseTo(boolean flag) {
        this.checkInResponseToPredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setCheckInResponseToPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.checkInResponseToPredicate = (Predicate)Constraint.isNotNull(condition, (String)"InResponseTo checking predicate cannot be null");
    }

    public boolean isAllowUnsolicited(@Nullable ProfileRequestContext profileRequestContext) {
        return this.allowUnsolicitedPredicate.test(profileRequestContext);
    }

    public void setAllowUnsolicited(boolean flag) {
        this.allowUnsolicitedPredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setAllowUnsolicitedPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.allowUnsolicitedPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Unsolicited response predicate cannot be null");
    }

    @Nullable
    public Duration getMaximumTimeSinceAuthn(@Nullable ProfileRequestContext profileRequestContext) {
        Duration amount = this.maximumTimeSinceAuthnLookupStrategy.apply(profileRequestContext);
        Constraint.isFalse((amount != null && amount.isNegative() ? 1 : 0) != 0, (String)"Maximum time since authentication must be greater than or equal to 0");
        return amount;
    }

    public void setMaximumTimeSinceAuthn(@Nullable Duration amount) {
        Constraint.isFalse((amount != null && amount.isNegative() ? 1 : 0) != 0, (String)"Maximum time since authentication must be greater than or equal to 0");
        this.maximumTimeSinceAuthnLookupStrategy = FunctionSupport.constant((Object)amount);
    }

    public void setMaximumTimeSinceAuthnLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        this.maximumTimeSinceAuthnLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    @NonNegative
    public Integer getProxyCount(@Nullable ProfileRequestContext profileRequestContext) {
        Integer count = this.proxyCountLookupStrategy.apply(profileRequestContext);
        if (count != null) {
            Constraint.isGreaterThanOrEqual((int)0, (int)count, (String)"Proxy count must be greater than or equal to 0");
        }
        return count;
    }

    public void setProxyCount(@Nullable @NonNegative Integer count) {
        if (count != null) {
            Constraint.isGreaterThanOrEqual((int)0, (int)count, (String)"Proxy count must be greater than or equal to 0");
        }
        this.proxyCountLookupStrategy = FunctionSupport.constant((Object)count);
    }

    public void setProxyCountLookupStrategy(@Nonnull Function<ProfileRequestContext, Integer> strategy) {
        this.proxyCountLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    public AuthnContextComparisonTypeEnumeration getAuthnContextComparison(@Nullable ProfileRequestContext profileRequestContext) {
        String comparison = this.authnContextComparisonLookupStrategy.apply(profileRequestContext);
        if (comparison != null) {
            return AuthnContextComparisonTypeEnumeration.valueOf((String)comparison.toUpperCase());
        }
        return null;
    }

    public void setAuthnContextComparison(@Nullable AuthnContextComparisonTypeEnumeration comparison) {
        this.authnContextComparisonLookupStrategy = FunctionSupport.constant((Object)(comparison != null ? comparison.toString() : null));
    }

    public void setAuthnContextComparisonLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.authnContextComparisonLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<String> getAuthnContextClassRefs(@Nullable ProfileRequestContext profileRequestContext) {
        Collection<String> refs = this.authnContextClassRefLookupStrategy.apply(profileRequestContext);
        if (refs != null) {
            return CollectionSupport.copyToList(refs);
        }
        return CollectionSupport.emptyList();
    }

    public void setAuthnContextClassRefs(@Nullable @NonnullElements Collection<String> contexts) {
        this.authnContextClassRefLookupStrategy = contexts != null ? FunctionSupport.constant((Object)CollectionSupport.copyToList(contexts)) : FunctionSupport.constant(null);
    }

    public void setAuthnContextClassRefsLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<String>> strategy) {
        this.authnContextClassRefLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    public String getNameIDFormat(@Nullable ProfileRequestContext profileRequestContext) {
        return this.nameIDFormatLookupStrategy.apply(profileRequestContext);
    }

    public void setNameIDFormat(@Nullable String format) {
        this.nameIDFormatLookupStrategy = FunctionSupport.constant((Object)format);
    }

    public void setNameIDFormatLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.nameIDFormatLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    public String getSPNameQualifier(@Nullable ProfileRequestContext profileRequestContext) {
        return this.nameQualifierLookupStrategy.apply(profileRequestContext);
    }

    public void setSPNameQualifier(@Nullable String qualifier) {
        this.nameQualifierLookupStrategy = FunctionSupport.constant((Object)qualifier);
    }

    public void setSPNameQualifierLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.nameQualifierLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    public Integer getAttributeIndex(@Nullable ProfileRequestContext profileRequestContext) {
        return this.attributeIndexLookupStrategy.apply(profileRequestContext);
    }

    public void setAttributeIndex(@Nullable Integer index) {
        this.attributeIndexLookupStrategy = FunctionSupport.constant((Object)index);
    }

    public void setAttributeIndexLookupStrategy(@Nonnull Function<ProfileRequestContext, Integer> strategy) {
        this.attributeIndexLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public Collection<RequestedAttribute> getRequestedAttributes(@Nullable ProfileRequestContext profileRequestContext) {
        Collection<RequestedAttribute> attrs = this.requestedAttributesLookupStrategy.apply(profileRequestContext);
        if (attrs != null) {
            return CollectionSupport.copyToList(attrs);
        }
        return CollectionSupport.emptyList();
    }

    public void setRequestedAttributes(@Nullable @NonnullElements Collection<RequestedAttribute> attrs) {
        this.requestedAttributesLookupStrategy = FunctionSupport.constant(attrs);
    }

    public void setRequestedAttributesLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<RequestedAttribute>> strategy) {
        this.requestedAttributesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    public String getResponseBinding(@Nullable ProfileRequestContext profileRequestContext) {
        return this.responseBindingLookupStrategy.apply(profileRequestContext);
    }

    public void setResponseBinding(@Nullable String binding) {
        this.responseBindingLookupStrategy = FunctionSupport.constant((Object)binding);
    }

    public void setResponseBindingLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.responseBindingLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Response binding lookup strategy cannot be null");
    }

    public boolean isExtractStandardAttributes(@Nullable ProfileRequestContext profileRequestContext) {
        return this.extractStandardAttributesPredicate.test(profileRequestContext);
    }

    public void setExtractStandardAttributes(boolean flag) {
        this.extractStandardAttributesPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setExtractStandardAttributesPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.extractStandardAttributesPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Standard extraction predicate cannot be null");
    }

    @Nullable
    public Function<ProfileRequestContext, Collection<IdPAttribute>> getAttributeExtractionStrategy(@Nullable ProfileRequestContext profileRequestContext) {
        return this.attributeExtractionStrategyLookupStrategy.apply(profileRequestContext);
    }

    public void setAttributeExtractionStrategy(@Nonnull Function<ProfileRequestContext, Collection<IdPAttribute>> strategy) {
        this.attributeExtractionStrategyLookupStrategy = FunctionSupport.constant(strategy);
    }

    public void setAttributeExtractionStrategyLookupStrategy(@Nonnull Function<ProfileRequestContext, Function<ProfileRequestContext, Collection<IdPAttribute>>> strategy) {
        this.attributeExtractionStrategyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Attribute extraction strategy lookup strategy cannot be null");
    }

    @Nullable
    public String getAttributeResolutionPrincipal(@Nullable ProfileRequestContext profileRequestContext) {
        return this.attributeResolutionPrincipalLookupStrategy.apply(profileRequestContext);
    }

    public void setAttributeResolutionPrincipal(@Nullable String principal) {
        this.attributeResolutionPrincipalLookupStrategy = FunctionSupport.constant((Object)principal);
    }

    public void setAttributeResolutionPrincipalLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.attributeResolutionPrincipalLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Resolution principal lookup strategy cannot be null");
    }
}

