/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.saml.saml2.profile.config.impl;

import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.profile.config.AbstractConditionalProfileConfiguration;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.sp.saml.saml2.profile.config.SAML2ProfileConfiguration;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;

public abstract class AbstractSAML2ProfileConfiguration
extends AbstractConditionalProfileConfiguration
implements SAML2ProfileConfiguration {
    @Nonnull
    private Function<ProfileRequestContext, String> entityIDLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Predicate<ProfileRequestContext> signRequestsPredicate = PredicateSupport.alwaysFalse();
    @Nonnull
    private Predicate<ProfileRequestContext> signResponsesPredicate = PredicateSupport.alwaysFalse();
    @Nonnull
    private Predicate<ProfileRequestContext> encryptionOptionalPredicate = PredicateSupport.alwaysFalse();
    @Nonnull
    private Predicate<ProfileRequestContext> encryptNameIDsPredicate = PredicateSupport.alwaysFalse();
    @Nonnull
    private Function<MessageContext, Function<MessageContext, Exception>> messageHandlerLookupStrategy = FunctionSupport.constant(null);

    public AbstractSAML2ProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
    }

    public boolean isIgnoreRequestSignatures(@Nullable ProfileRequestContext profileRequestContext) {
        throw new UnsupportedOperationException("ignoreRequestSignatures is unsupported");
    }

    @Nullable
    @NotEmpty
    public String getEntityID(@Nullable ProfileRequestContext profileRequestContext) {
        return this.entityIDLookupStrategy.apply(profileRequestContext);
    }

    public void setEntityID(@Nullable @NotEmpty String id) {
        this.entityIDLookupStrategy = FunctionSupport.constant((Object)id);
    }

    public void setEntityIDLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.entityIDLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"EntityID lookup strategy cannot be null");
    }

    public boolean isSignRequests(@Nullable ProfileRequestContext profileRequestContext) {
        return this.signRequestsPredicate.test(profileRequestContext);
    }

    public void setSignRequests(boolean flag) {
        this.signRequestsPredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setSignRequestsPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.signRequestsPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Condition cannot be null");
    }

    public boolean isSignResponses(@Nullable ProfileRequestContext profileRequestContext) {
        return this.signResponsesPredicate.test(profileRequestContext);
    }

    public void setSignResponses(boolean flag) {
        this.signResponsesPredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setSignResponsesPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.signResponsesPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Condition cannot be null");
    }

    public boolean isEncryptionOptional(@Nullable ProfileRequestContext profileRequestContext) {
        return this.encryptionOptionalPredicate.test(profileRequestContext);
    }

    public void setEncryptionOptional(boolean flag) {
        this.encryptionOptionalPredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setEncryptionOptionalPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.encryptionOptionalPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Encryption optional predicate cannot be null");
    }

    public boolean isEncryptNameIDs(@Nullable ProfileRequestContext profileRequestContext) {
        return this.encryptNameIDsPredicate.test(profileRequestContext);
    }

    public void setEncryptNameIDs(boolean flag) {
        this.encryptNameIDsPredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setEncryptNameIDsPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.encryptNameIDsPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Condition cannot be null");
    }

    @Nullable
    public Function<MessageContext, Exception> getMessageHandler(@Nullable MessageContext messageContext) {
        return this.messageHandlerLookupStrategy.apply(messageContext);
    }

    public void setMessageHandler(@Nullable Function<MessageContext, Exception> handler) {
        this.messageHandlerLookupStrategy = FunctionSupport.constant(handler);
    }

    public void setMessageHandlerLookupStrategy(@Nonnull Function<MessageContext, Function<MessageContext, Exception>> strategy) {
        this.messageHandlerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }
}

