/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.saml.saml2.profile.config.impl;

import java.time.Duration;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.saml.profile.config.SAMLAssertionConsumingProfileConfiguration;
import net.shibboleth.shared.annotation.constraint.NonNegative;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.sp.saml.saml2.profile.config.impl.AbstractSAML2ArtifactConsumerProfileConfiguration;
import org.opensaml.profile.context.ProfileRequestContext;

public abstract class AbstractSAML2AssertionConsumerProfileConfiguration
extends AbstractSAML2ArtifactConsumerProfileConfiguration
implements SAMLAssertionConsumingProfileConfiguration {
    @Nonnull
    private Predicate<ProfileRequestContext> requireSignedAssertionsPredicate = PredicateSupport.alwaysFalse();
    @Nonnull
    private Function<ProfileRequestContext, Duration> assertionLifetimeLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Function<ProfileRequestContext, Set<String>> assertionAudiencesLookupStrategy = FunctionSupport.constant(null);

    public AbstractSAML2AssertionConsumerProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
    }

    public boolean isRequireSignedAssertions(@Nullable ProfileRequestContext profileRequestContext) {
        return this.requireSignedAssertionsPredicate.test(profileRequestContext);
    }

    public void setRequireSignedAssertions(boolean flag) {
        this.requireSignedAssertionsPredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setRequireSignedAssertionsPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.requireSignedAssertionsPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    @Nullable
    @NonNegative
    public Duration getAssertionLifetime(@Nullable ProfileRequestContext profileRequestContext) {
        Duration lifetime = this.assertionLifetimeLookupStrategy.apply(profileRequestContext);
        if (lifetime != null) {
            Constraint.isFalse((boolean)lifetime.isNegative(), (String)"Assertion lifetime must be non-negative");
        }
        return lifetime;
    }

    public void setAssertionLifetime(@Nullable @NonNegative Duration lifetime) {
        if (lifetime != null) {
            Constraint.isFalse((boolean)lifetime.isNegative(), (String)"Assertion lifetime must be non-negative");
        }
        this.assertionLifetimeLookupStrategy = FunctionSupport.constant((Object)lifetime);
    }

    public void setAssertionLifetimeLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        this.assertionLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @NonnullElements
    @NotLive
    public Set<String> getAssertionAudiences(@Nullable ProfileRequestContext profileRequestContext) {
        Set<String> audiences = this.assertionAudiencesLookupStrategy.apply(profileRequestContext);
        if (audiences != null) {
            return CollectionSupport.copyToSet(audiences);
        }
        return CollectionSupport.emptySet();
    }

    public void setAssertionAudiences(@Nullable @NonnullElements Collection<String> audiences) {
        this.assertionAudiencesLookupStrategy = audiences == null || audiences.isEmpty() ? FunctionSupport.constant(null) : FunctionSupport.constant((Object)CollectionSupport.copyToSet((Collection)StringSupport.normalizeStringCollection(audiences)));
    }

    public void setAssertionAudiencesLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<String>> strategy) {
        this.assertionAudiencesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }
}

