/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.profile.context.navigate.messaging;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.sp.context.AgentRequestContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.ParentContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;

public abstract class AbstractAgentRequestLookupFunction<T>
implements Function<MessageContext, T> {
    @Nonnull
    private Function<MessageContext, AgentRequestContext> agentRequestContextLookupStrategy = new ChildContextLookup(AgentRequestContext.class).compose((Function)new ParentContextLookup(ProfileRequestContext.class));

    public void setAgentRequestContextLookupStrategy(@Nonnull Function<MessageContext, AgentRequestContext> strategy) {
        this.agentRequestContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AgentRequestContext lookup strategy cannot be null");
    }

    @Nullable
    public AgentRequestContext getAgentRequestContext(@Nullable MessageContext messageContext) {
        return this.agentRequestContextLookupStrategy.apply(messageContext);
    }

    @Nonnull
    public AgentRequestContext ensureAgentRequestContext(@Nullable MessageContext messageContext) {
        AgentRequestContext arc = this.agentRequestContextLookupStrategy.apply(messageContext);
        if (arc == null) {
            throw new IllegalStateException("AgentRequestContext was missing");
        }
        return arc;
    }
}

