/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.profile;

import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.ByteAttributeValue;
import net.shibboleth.idp.attribute.DateTimeAttributeValue;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.codec.EncodingException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.sp.context.AgentRequestContext;
import net.shibboleth.sp.ddf.DDF;
import net.shibboleth.sp.messaging.RemotedHttpServletResponse;
import net.shibboleth.sp.profile.AbstractApplicationAction;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public abstract class AbstractTokenConsumerResponseAction
extends AbstractApplicationAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AbstractTokenConsumerResponseAction.class);
    @Nonnull
    private Function<ProfileRequestContext, AttributeContext> attributeContextLookupStrategy = new ChildContextLookup(AttributeContext.class);

    public AbstractTokenConsumerResponseAction() {
        this.setCreateOutputObjects(true);
    }

    public void setAttributeContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AttributeContext> strategy) {
        this.checkSetterPreconditions();
        this.attributeContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeContext lookup strategy cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        this.ensureOutputObjects();
        AgentRequestContext agentRequestContext = this.ensureAgentRequestContext();
        DDF output = agentRequestContext.getOutput();
        assert (output != null);
        AttributeContext attributeContext = this.attributeContextLookupStrategy.apply(profileRequestContext);
        if (attributeContext != null && !attributeContext.getIdPAttributes().isEmpty()) {
            this.log.debug("{} Serializing attributes for agent", (Object)this.getLogPrefix());
            DDF attrlist = output.addmember("session.attributes").list();
            attributeContext.getIdPAttributes().forEach((id, attr) -> {
                DDF obj = new DDF((String)id).list();
                for (IdPAttributeValue value : attr.getValues()) {
                    if (value instanceof ScopedStringAttributeValue) {
                        ScopedStringAttributeValue scoped = (ScopedStringAttributeValue)value;
                        DDF valobj = new DDF(null).structure();
                        valobj.addmember("value").string(scoped.getValue());
                        valobj.addmember("scope").string(scoped.getScope());
                        obj.add(valobj);
                        continue;
                    }
                    if (value instanceof StringAttributeValue) {
                        StringAttributeValue str = (StringAttributeValue)value;
                        obj.add(new DDF(null).string(str.getValue()));
                        continue;
                    }
                    if (value instanceof DateTimeAttributeValue) {
                        DateTimeAttributeValue datetime = (DateTimeAttributeValue)value;
                        obj.add(new DDF(null).longinteger(datetime.getValue().getEpochSecond()));
                        continue;
                    }
                    if (value instanceof ByteAttributeValue) {
                        ByteAttributeValue bytes = (ByteAttributeValue)value;
                        try {
                            obj.add(new DDF(null).string(Base64Support.encode((byte[])bytes.getValue(), (boolean)false)));
                        }
                        catch (EncodingException e) {
                            this.log.warn("{} Error base64-encoding ByteAttributeValue", (Object)this.getLogPrefix(), (Object)e);
                        }
                        continue;
                    }
                    this.log.warn("{} Unsupported attribute value type: {}", (Object)this.getLogPrefix(), (Object)value.getClass().getName());
                }
                attrlist.add(obj);
            });
        } else {
            this.log.debug("{} No AttributeContext or no attributes found", (Object)this.getLogPrefix());
        }
        String sessionData = this.getSessionData(profileRequestContext);
        if (sessionData != null) {
            output.addmember("session.opaque").string(sessionData);
        }
        RemotedHttpServletResponse remotedResponse = agentRequestContext.getRemotedHttpServletResponse();
        assert (remotedResponse != null);
        if (!remotedResponse.isCommitted()) {
            byte[] resource = agentRequestContext.getTargetURL();
            if (resource == null || resource.length == 0) {
                DDF in = agentRequestContext.getInput();
                if (in != null) {
                    resource = in.getmember("base_url").unsafe_string();
                }
                if (resource == null || resource.length == 0) {
                    resource = "/".getBytes(StandardCharsets.UTF_8);
                }
                agentRequestContext.setTargetURL(resource);
            }
            output.addmember("target").unsafe_string(resource);
            remotedResponse.sendRedirect(resource);
        }
    }

    @Nullable
    protected abstract String getSessionData(@Nonnull ProfileRequestContext var1);
}

