/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.profile;

import java.time.Duration;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import net.shibboleth.sp.profile.StateTokenManager;

public abstract class AbstractStateTokenManager
extends AbstractIdentifiableInitializableComponent
implements StateTokenManager {
    @NonnullAfterInit
    private IdentifierGenerationStrategy identifierStrategy;
    @Nonnull
    private Duration expiration = Duration.ofMinutes(30L);

    @NonnullAfterInit
    public IdentifierGenerationStrategy getIdentifierGenerationStrategy() {
        return this.identifierStrategy;
    }

    public void setIdentifierGenerationStrategy(@Nonnull IdentifierGenerationStrategy strategy) {
        this.checkSetterPreconditions();
        this.identifierStrategy = (IdentifierGenerationStrategy)Constraint.isNotNull((Object)strategy, (String)"IdentifierGenerationStrategy cannot be null");
    }

    @Nonnull
    public Duration getExpiration() {
        return this.expiration;
    }

    public void setExpiration(@Nonnull Duration exp) {
        this.checkSetterPreconditions();
        this.expiration = (Duration)Constraint.isNotNull((Object)exp, (String)"Expiration cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.identifierStrategy == null) {
            this.identifierStrategy = IdentifierGenerationStrategy.getInstance((IdentifierGenerationStrategy.ProviderType)IdentifierGenerationStrategy.ProviderType.SECURE);
        }
    }

    @Nonnull
    protected String generateToken() {
        return this.identifierStrategy.generateIdentifier(false);
    }
}

