/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.profile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.sp.Application;
import net.shibboleth.sp.profile.AbstractAgentAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public abstract class AbstractApplicationAction
extends AbstractAgentAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractApplicationAction.class);
    @NonnullBeforeExec
    private Application application;

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.application = this.ensureAgentRequestContext().getApplication();
        if (this.application == null) {
            this.log.error("{} No Application found in context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        return true;
    }

    @Nullable
    public Application getApplication() {
        return this.application;
    }

    @Nonnull
    public Application ensureApplication() {
        return (Application)Constraint.isNotNull((Object)this.application, (String)"Application was null");
    }
}

