/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.messaging;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.sp.ddf.DDF;

@NotThreadSafe
public class RemotedHttpServletResponse
implements HttpServletResponse {
    @Nonnull
    @NotEmpty
    public static final String STRUCTURE_NAME = "http";
    @Nonnull
    @NotEmpty
    public static final String REDIRECT = "redirect";
    @Nonnull
    @NotEmpty
    public static final String RESPONSE = "response";
    @Nonnull
    @NotEmpty
    public static final String DATA = "data";
    @Nonnull
    @NotEmpty
    public static final String STATUS = "status";
    @Nonnull
    @NotEmpty
    public static final String HEADERS = "headers";
    @Nonnull
    private final DDF obj;
    private int bufferSize;
    private boolean committed;
    @Nullable
    private BodyOutputStream outputStream;

    public RemotedHttpServletResponse(@Nonnull DDF ddf) {
        this.obj = (DDF)Constraint.isNotNull((Object)ddf, (String)"DDF cannot be null");
        this.obj.structure();
        this.bufferSize = 1024;
    }

    @Nonnull
    public DDF getDDF() {
        return this.obj;
    }

    public String getCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.committed) {
            throw new IllegalStateException("Response already committed");
        }
        if (this.outputStream == null) {
            this.outputStream = new BodyOutputStream();
        }
        return this.outputStream;
    }

    public PrintWriter getWriter() throws IOException {
        return new PrintWriter((OutputStream)this.getOutputStream(), false, Charset.forName(this.getCharacterEncoding()));
    }

    public void setCharacterEncoding(String charset) {
        if (!StandardCharsets.UTF_8.name().equals(charset)) {
            throw new IllegalArgumentException("Character set must be UTF-8.");
        }
    }

    public void setContentLength(int len) {
        this.setIntHeader("Content-Length", len);
    }

    public void setContentLengthLong(long len) {
        this.setHeader("Content-Length", Long.toString(len));
    }

    public void setContentType(String type) {
        this.setHeader("Content-Type", type);
    }

    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void flushBuffer() throws IOException {
        this.committed = true;
    }

    public void resetBuffer() {
        if (this.committed) {
            throw new IllegalStateException("Response already committed");
        }
        if (this.outputStream != null) {
            this.outputStream.reset();
        }
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void reset() {
        if (this.committed) {
            throw new IllegalStateException("Response already committed");
        }
        this.outputStream = null;
        this.obj.structure();
    }

    public void setLocale(Locale loc) {
        throw new UnsupportedOperationException();
    }

    public Locale getLocale() {
        throw new UnsupportedOperationException();
    }

    public void addCookie(Cookie cookie) {
        StringBuffer buffer = new StringBuffer(cookie.getName()).append('=');
        if (cookie.getValue() != null) {
            buffer.append(cookie.getValue());
        }
        cookie.getAttributes().forEach((n, v) -> buffer.append("; ").append((String)n).append('=').append((String)v));
        this.addHeader("Set-Cookie", buffer.toString());
    }

    public boolean containsHeader(String name) {
        for (DDF header : this.obj.getmember(HEADERS).asList()) {
            if (!name.equals(header.name())) continue;
            return true;
        }
        return false;
    }

    public String encodeURL(String url) {
        return url;
    }

    public String encodeRedirectURL(String url) {
        return url;
    }

    public void sendError(int sc, String msg) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void sendError(int sc) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void sendRedirect(String location) throws IOException {
        this.sendRedirect(location.getBytes(StandardCharsets.UTF_8));
    }

    public void sendRedirect(byte[] location) {
        if (this.committed) {
            throw new IllegalStateException("Response already committed");
        }
        this.obj.getmember(RESPONSE).remove();
        this.obj.addmember(REDIRECT).unsafe_string(location);
        this.committed = true;
        this.outputStream = null;
    }

    public void setDateHeader(String name, long date) {
        if (name != null) {
            this.unsetHeader(name);
            this.addDateHeader(name, date);
        }
    }

    public void addDateHeader(String name, long date) {
        if (name != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
            formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
            this.addHeader(name, formatter.format(Date.from(Instant.ofEpochMilli(date))));
        }
    }

    public void setHeader(String name, String value) {
        if (name != null) {
            this.unsetHeader(name);
            this.addHeader(name, value);
        }
    }

    public void addHeader(String name, String value) {
        if (name != null) {
            this.getHeaderList().add(new DDF(name).string(value));
        }
    }

    public void setIntHeader(String name, int value) {
        if (name != null) {
            this.unsetHeader(name);
            this.addIntHeader(name, value);
        }
    }

    public void addIntHeader(String name, int value) {
        if (name != null) {
            this.getHeaderList().add(new DDF(name).integer(value));
        }
    }

    public void setStatus(int sc) {
        this.obj.addmember("response.status").integer(sc);
    }

    public int getStatus() {
        Integer i = this.obj.getmember("response.status").integer();
        return i != null ? i : -1;
    }

    public String getHeader(String name) {
        Optional<DDF> header = this.obj.getmember(HEADERS).asList().stream().filter(ddf -> name.equalsIgnoreCase(ddf.name())).findFirst();
        if (header.isPresent()) {
            if (header.orElseThrow().isstring()) {
                return header.orElseThrow().string();
            }
            Integer i = header.orElseThrow().integer();
            if (i != null) {
                return i.toString();
            }
        }
        return null;
    }

    public Collection<String> getHeaders(String name) {
        return this.obj.getmember(HEADERS).asList().stream().filter(ddf -> name.equalsIgnoreCase(ddf.name())).map(DDF::string).collect(Collectors.toUnmodifiableList());
    }

    public Collection<String> getHeaderNames() {
        return this.obj.getmember(HEADERS).asList().stream().map(DDF::name).collect(Collectors.toUnmodifiableSet());
    }

    private void unsetHeader(@Nonnull @NotEmpty String name) {
        if (this.committed) {
            throw new IllegalStateException("Response already committed");
        }
        this.obj.getmember(HEADERS).asList().stream().filter(ddf -> name.equalsIgnoreCase(ddf.name())).forEach(DDF::remove);
    }

    @Nonnull
    private DDF getHeaderList() {
        if (this.committed) {
            throw new IllegalStateException("Response already committed");
        }
        DDF headers = this.obj.getmember(HEADERS);
        if (headers.islist()) {
            return headers;
        }
        return this.obj.addmember(HEADERS).list();
    }

    private class BodyOutputStream
    extends ServletOutputStream {
        @Nonnull
        @NonnullElements
        private final ArrayList<ByteArrayWrapper> bufferList;
        @Nonnull
        private ByteArrayWrapper currentBuffer;

        public BodyOutputStream() {
            this.currentBuffer = new ByteArrayWrapper(RemotedHttpServletResponse.this.bufferSize);
            this.bufferList = new ArrayList(1);
            this.bufferList.add(this.currentBuffer);
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener writeListener) {
            throw new UnsupportedOperationException();
        }

        public void write(int b) throws IOException {
            if (!this.currentBuffer.write(b)) {
                this.currentBuffer = new ByteArrayWrapper(RemotedHttpServletResponse.this.bufferSize);
                this.bufferList.add(this.currentBuffer);
                Constraint.isTrue((boolean)this.currentBuffer.write(b), (String)"Fresh buffer cannot fail to accept data");
            }
        }

        public void flush() throws IOException {
            int offset = 0;
            byte[] copy = new byte[(this.bufferList.size() - 1) * RemotedHttpServletResponse.this.bufferSize + this.bufferList.get(this.bufferList.size() - 1).getOffset()];
            for (ByteArrayWrapper b : this.bufferList) {
                System.arraycopy(b.getBuffer(), 0, copy, offset, b.getOffset());
                offset += b.getOffset();
            }
            RemotedHttpServletResponse.this.obj.addmember("response.data").unsafe_string(copy);
            RemotedHttpServletResponse.this.committed = true;
        }

        public void close() throws IOException {
            this.flush();
        }

        private void reset() {
            this.currentBuffer = new ByteArrayWrapper(RemotedHttpServletResponse.this.bufferSize);
            this.bufferList.clear();
            this.bufferList.add(this.currentBuffer);
        }
    }

    private static final class ByteArrayWrapper {
        private int offset;
        @Nonnull
        private final byte[] buffer;

        private ByteArrayWrapper(int size) {
            this.buffer = new byte[size];
            this.offset = 0;
        }

        @Nonnull
        private byte[] getBuffer() {
            return this.buffer;
        }

        private int getOffset() {
            return this.offset;
        }

        private boolean write(int b) {
            if (this.offset < this.buffer.length) {
                this.buffer[this.offset++] = Integer.valueOf(b).byteValue();
                return true;
            }
            return false;
        }
    }
}

