/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.messaging;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.sp.messaging.RemotedHttpServletRequest;
import net.shibboleth.sp.messaging.RemotedHttpServletResponse;

public final class RemotedHttpServletRequestResponseContext {
    @Nonnull
    private static final ThreadLocal<RemotedHttpServletRequest> currentRequest = new ThreadLocal();
    @Nonnull
    private static final ThreadLocal<RemotedHttpServletResponse> currentResponse = new ThreadLocal();

    private RemotedHttpServletRequestResponseContext() {
    }

    public static void loadCurrent(@Nullable RemotedHttpServletRequest request, @Nullable RemotedHttpServletResponse response) {
        currentRequest.set(request);
        currentResponse.set(response);
    }

    public static void clearCurrent() {
        currentRequest.remove();
        currentResponse.remove();
    }

    @Nullable
    public static RemotedHttpServletRequest getRequest() {
        return currentRequest.get();
    }

    @Nullable
    public static RemotedHttpServletResponse getResponse() {
        return currentResponse.get();
    }
}

