/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.ddf;

import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.xml.ElementSupport;
import net.shibboleth.sp.ddf.DDF;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class DDFSupport {
    @Nonnull
    @NotEmpty
    public static final String CHILD_ELEMENTS_MEMBER = "_children";
    @Nonnull
    @NotEmpty
    public static final String CONTENT_MEMBER = "_content";

    private DDFSupport() {
    }

    @Nonnull
    public static DDF fromElement(@Nonnull Element element) {
        Constraint.isNotNull((Object)element, (String)"Element cannot be null");
        DDF obj = new DDF(element.getLocalName());
        NamedNodeMap attrs = element.getAttributes();
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                Attr attr = (Attr)attrs.item(i);
                obj.addmember(attr.getLocalName()).string(attr.getValue());
            }
        }
        DDF children = null;
        Element child = ElementSupport.getFirstChildElement((Node)element);
        while (child != null) {
            if (children == null) {
                children = obj.addmember(CHILD_ELEMENTS_MEMBER).list();
            }
            children.add(DDFSupport.fromElement(child));
            child = ElementSupport.getNextSiblingElement((Node)child);
        }
        String content = ElementSupport.getElementContentAsString((Element)element);
        if (content != null && !content.isBlank()) {
            obj.addmember(CONTENT_MEMBER).string(content);
        }
        return obj;
    }
}

