/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.profile.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.sp.ddf.DDF;
import net.shibboleth.sp.profile.AbstractApplicationAction;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ValidateSessionInitiatorRequest
extends AbstractApplicationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ValidateSessionInitiatorRequest.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextCreationStrategy = new ChildContextLookup(RelyingPartyContext.class, true);
    @Nullable
    private String flowId;
    private boolean requireRelyingPartyId;
    private boolean requireDiscoveryURL;
    @Nullable
    private String relyingPartyId;

    public void setFlowId(@Nullable String id) {
        this.checkSetterPreconditions();
        this.flowId = StringSupport.trimOrNull((String)id);
    }

    public void setRelyingPartyContextCreationStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.checkSetterPreconditions();
        this.relyingPartyContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext creation strategy cannot be null");
    }

    public void setRequireRelyingPartyId(boolean flag) {
        this.checkSetterPreconditions();
        this.requireRelyingPartyId = flag;
    }

    public void setRequireDiscoveryURL(boolean flag) {
        this.checkSetterPreconditions();
        this.requireDiscoveryURL = flag;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.log.debug("{} Evaluating applicability of request to {} session initiator flow", (Object)this.getLogPrefix(), (Object)this.flowId);
        DDF input = this.ensureAgentRequestContext().getInput();
        if (input == null) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            this.log.error("{} No input message from agent", (Object)this.getLogPrefix());
            return false;
        }
        if (this.requireDiscoveryURL && StringSupport.trimOrNull((String)input.getmember("disco_return_url").string()) == null) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            this.log.info("{} Input message missing '{}' parameter, {} flow skipped", new Object[]{this.getLogPrefix(), "disco_return_url", this.flowId});
            return false;
        }
        this.relyingPartyId = input.getmember("authority").string();
        if (this.relyingPartyId == null) {
            this.relyingPartyId = input.getmember("entityID").string();
        }
        if (this.relyingPartyId == null) {
            this.relyingPartyId = this.ensureApplication().getAuthenticatingAuthority(profileRequestContext);
        }
        if (this.requireRelyingPartyId) {
            if (this.relyingPartyId == null) {
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
                this.log.debug("{} Authenticating authority unknown, {} flow skipped", (Object)this.getLogPrefix(), (Object)this.flowId);
                return false;
            }
            return true;
        }
        if (this.relyingPartyId != null) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            this.log.warn("{} Authenticating authority provided, but not expected by {} flow, loop may result", (Object)this.getLogPrefix(), (Object)this.flowId);
            return false;
        }
        return false;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        RelyingPartyContext rpContext = this.relyingPartyContextCreationStrategy.apply(profileRequestContext);
        if (rpContext == null) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
            this.log.error("{} Unable to create RelyingPartyContext", (Object)this.getLogPrefix());
            return;
        }
        rpContext.setRelyingPartyId(this.relyingPartyId);
        this.log.debug("{} Initialized RelyingPartyContext for {}", (Object)this.getLogPrefix(), (Object)(this.relyingPartyId != null ? this.relyingPartyId : "unidentified authority"));
    }
}

