/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.profile.impl;

import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.Positive;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.net.CookieManager;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import net.shibboleth.sp.context.AgentRequestContext;
import net.shibboleth.sp.ddf.DDF;
import net.shibboleth.sp.messaging.RemotedHttpServletRequest;
import net.shibboleth.sp.messaging.RemotedHttpServletRequestResponseContext;
import net.shibboleth.sp.messaging.RemotedHttpServletResponse;
import net.shibboleth.sp.profile.AbstractApplicationAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.StorageService;
import org.slf4j.Logger;

public class PreservePostData
extends AbstractApplicationAction {
    @Nonnull
    @NotEmpty
    public static String DEFAULT_COOKIE_PREFIX = "_shibsp_post_";
    @Nonnull
    private Logger log = LoggerFactory.getLogger(PreservePostData.class);
    @NonnullAfterInit
    private IdentifierGenerationStrategy identifierStrategy;
    @Nonnull
    private Duration lifetime = Duration.ofMinutes(5L);
    @NonnullAfterInit
    private StorageService storageService;
    @NonnullAfterInit
    private CookieManager cookieManager;
    @Nonnull
    private String cookiePrefix = DEFAULT_COOKIE_PREFIX;
    private boolean errorFatal;
    @NonnullBeforeExec
    private String stateToken;
    @NonnullBeforeExec
    private byte[] postData;

    public void setIdentifierGenerationStrategy(@Nonnull IdentifierGenerationStrategy strategy) {
        this.checkSetterPreconditions();
        this.identifierStrategy = (IdentifierGenerationStrategy)Constraint.isNotNull((Object)strategy, (String)"IdentifierGenerationStrategy cannot be null");
    }

    public void setLifetime(@Nonnull @Positive Duration dur) {
        this.checkSetterPreconditions();
        Constraint.isFalse((this.lifetime == null || this.lifetime.isNegative() || this.lifetime.isZero() ? 1 : 0) != 0, (String)"Lifetime cannot be zero or negative");
        this.lifetime = dur;
    }

    public void setStorageService(@Nonnull StorageService storage) {
        this.checkSetterPreconditions();
        this.storageService = (StorageService)Constraint.isNotNull((Object)storage, (String)"StorageService cannot be null");
    }

    public void setCookieManager(@Nonnull CookieManager manager) {
        this.checkSetterPreconditions();
        this.cookieManager = (CookieManager)Constraint.isNotNull((Object)manager, (String)"CookieManager cannot be null");
    }

    public void setCookiePrefix(@Nonnull @NotEmpty String prefix) {
        this.checkSetterPreconditions();
        this.cookiePrefix = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)prefix), (String)"Cookie prefix cannot be null or empty");
    }

    public void setErrorFatal(boolean flag) {
        this.checkSetterPreconditions();
        this.errorFatal = flag;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.identifierStrategy == null) {
            this.identifierStrategy = IdentifierGenerationStrategy.getInstance((IdentifierGenerationStrategy.ProviderType)IdentifierGenerationStrategy.ProviderType.SECURE);
        }
        if (this.cookieManager == null) {
            throw new ComponentInitializationException("CookieManager cannot be null");
        }
        if (this.storageService == null) {
            throw new ComponentInitializationException("StorageService cannot be null");
        }
        if (!this.storageService.getCapabilities().isServerSide()) {
            throw new ComponentInitializationException("StorageService cannot be client-side");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        DDF input = this.ensureAgentRequestContext().getInput();
        if (input != null) {
            this.postData = input.getmember("http").getmember("body").unsafe_string();
        }
        if (this.postData == null) {
            this.log.debug("{} No POST data to preserve", (Object)this.getLogPrefix());
            return false;
        }
        assert (input != null);
        String contentType = input.getmember("http").getmember("content_type").string();
        if (!"application/x-www-form-urlencoded".equals(contentType)) {
            this.log.warn("{} Unsupported content type: {}", (Object)this.getLogPrefix(), (Object)contentType);
            return false;
        }
        if (!this.ensureAgent().isSupportsPostPreservation()) {
            this.log.warn("{} POST data supplied for preservation, but not permitted for agent", (Object)this.getLogPrefix());
            return false;
        }
        long limit = this.ensureAgent().getPostLimit();
        if (limit > 0L && (long)this.postData.length > limit) {
            this.log.warn("{} POST data supplied for preservation, but size {} exceeds agent limit", (Object)this.getLogPrefix(), (Object)this.postData.length);
            return false;
        }
        if (input != null) {
            this.stateToken = input.getmember("state").string();
        }
        if (this.stateToken == null) {
            if (this.errorFatal) {
                this.log.warn("{} Input was missing {} parameter, failing due to POST data preservationr", (Object)this.getLogPrefix(), (Object)"state");
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            } else {
                this.log.warn("{} Input was missing {} parameter, skipping POST data preservation", (Object)this.getLogPrefix(), (Object)"state");
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        AgentRequestContext agentRequestContext = this.ensureAgentRequestContext();
        try {
            RemotedHttpServletRequestResponseContext.loadCurrent((RemotedHttpServletRequest)agentRequestContext.getRemotedHttpServletRequest(), (RemotedHttpServletResponse)agentRequestContext.getRemotedHttpServletResponse());
            this.cookieManager.purgeStaleCookies(this.cookiePrefix);
            this.log.debug("{} Preserving {} bytes of POST data against state token {}", new Object[]{this.getLogPrefix(), this.postData.length, this.stateToken});
            String encoded = new String(this.postData, StandardCharsets.UTF_8);
            String key = this.identifierStrategy.generateIdentifier(false);
            if (!this.storageService.create(this.ensureAgent().getId() + ".PostData", key, encoded, Long.valueOf(Instant.now().plus(this.lifetime).toEpochMilli()))) {
                this.log.warn("{} Collision attempting to create storage record for POST data under key {}", (Object)this.getLogPrefix(), (Object)key);
                if (this.errorFatal) {
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
                }
                return;
            }
            if (this.stateToken.length() > 16) {
                this.stateToken = this.stateToken.substring(0, 16);
            }
            Escaper escaper = UrlEscapers.urlFormParameterEscaper();
            this.cookieManager.addCookie(this.cookiePrefix + escaper.escape(this.stateToken), escaper.escape(key));
        }
        catch (IOException e) {
            this.log.error("{} Error creating storage record for POST data", (Object)this.getLogPrefix(), (Object)e);
            if (this.errorFatal) {
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
            }
        }
        finally {
            RemotedHttpServletRequestResponseContext.clearCurrent();
        }
    }
}

