/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.profile.impl;

import java.io.IOException;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.sp.context.AgentRequestContext;
import net.shibboleth.sp.ddf.DDF;
import net.shibboleth.sp.messaging.RemotedHttpServletRequest;
import net.shibboleth.sp.messaging.RemotedHttpServletRequestResponseContext;
import net.shibboleth.sp.messaging.RemotedHttpServletResponse;
import net.shibboleth.sp.profile.AbstractApplicationAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class MapResourceToStateToken
extends AbstractApplicationAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(MapResourceToStateToken.class);
    private boolean errorFatal;
    @NonnullBeforeExec
    private DDF input;
    @NonnullBeforeExec
    private byte[] target;

    public void setErrorFatal(boolean flag) {
        this.checkSetterPreconditions();
        this.errorFatal = flag;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.input = this.ensureAgentRequestContext().getInput();
        if (this.input == null) {
            this.log.debug("{} Input message was absent", (Object)this.getLogPrefix());
            return false;
        }
        if (this.input.getmember("state").isstring()) {
            this.log.debug("{} Input message already contains {} parameter", (Object)this.getLogPrefix(), (Object)"state");
            return false;
        }
        this.target = this.input.getmember("target").unsafe_string();
        if (this.target == null) {
            this.log.warn("{} Input message did not contain {} member", (Object)this.getLogPrefix(), (Object)"target");
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return false;
        }
        this.ensureAgentRequestContext().setTargetURL(this.target);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        this.ensureOutputObjects();
        AgentRequestContext agentRequestContext = this.ensureAgentRequestContext();
        try {
            RemotedHttpServletRequestResponseContext.loadCurrent((RemotedHttpServletRequest)agentRequestContext.getRemotedHttpServletRequest(), (RemotedHttpServletResponse)agentRequestContext.getRemotedHttpServletResponse());
            try {
                String token = this.ensureApplication().getStateTokenManager().preserveToStateToken(this.ensureAgent(), this.ensureApplication(), this.target);
                this.input.addmember("state").string(token);
                this.log.debug("{} Target resource preserved to state token: {}", (Object)this.getLogPrefix(), (Object)token);
            }
            catch (IOException e) {
                this.log.warn("{} Exception preserving target resource to state token", (Object)this.getLogPrefix(), (Object)e);
                if (this.errorFatal) {
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
                }
            }
        }
        finally {
            RemotedHttpServletRequestResponseContext.clearCurrent();
        }
    }
}

