/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.profile.impl;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.sp.Agent;
import net.shibboleth.sp.context.AgentRequestContext;
import net.shibboleth.sp.ddf.DDF;
import net.shibboleth.sp.profile.AbstractAgentRequestAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class EncodeAgentResponse
extends AbstractAgentRequestAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(EncodeAgentResponse.class);
    @NonnullBeforeExec
    private DDF outputMessage;

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        AgentRequestContext agentRequestContext = this.ensureAgentRequestContext();
        this.outputMessage = agentRequestContext.getOutput();
        if (this.outputMessage != null) {
            if (!this.outputMessage.isstruct()) {
                this.log.error("{} Output message was not a structure", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
                return false;
            }
        } else {
            this.log.debug("{} No output message found, creating an empty structure signalling success", (Object)this.getLogPrefix());
            agentRequestContext.setOutput(new DDF());
            this.outputMessage = agentRequestContext.getOutput();
            this.outputMessage.structure();
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        String sessionID;
        HttpServletRequest request;
        Agent agent;
        HttpServletResponse response = this.getHttpServletResponse();
        if (response == null) {
            this.log.error("{} No HttpServletResponse available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        if (this.outputMessage.getmember("event").isnull()) {
            this.outputMessage.addmember("event").string("success");
        }
        if ((agent = this.ensureAgentRequestContext().getAgent()) != null && agent.isSupportsCachedAuthentication() && (request = this.getHttpServletRequest()) != null && (sessionID = request.getSession(true).getId()) != null) {
            this.outputMessage.addmember("cached_auth").string(sessionID);
        }
        response.setContentType("text/plain");
        try (ServletOutputStream out = response.getOutputStream();){
            assert (out != null);
            this.outputMessage.serialize((OutputStream)out);
        }
        catch (IOException e) {
            this.log.warn("{} Unable to serialize output message", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
        }
    }
}

