/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.profile.impl;

import java.io.IOException;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.sp.ddf.DDF;
import net.shibboleth.sp.profile.AbstractAgentAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageService;
import org.opensaml.storage.VersionMismatchException;
import org.slf4j.Logger;

public class DoStorageOperation
extends AbstractAgentAction {
    @Nonnull
    @NotEmpty
    public static final String RECORD_NOT_FOUND = "RecordNotFound";
    @Nonnull
    @NotEmpty
    public static final String DUPLICATE_RECORD = "DuplicateRecord";
    @Nonnull
    @NotEmpty
    public static final String VERSION_MISMATCH = "VersionMismatch";
    @Nonnull
    @NotEmpty
    public static final String OP = "op";
    @Nonnull
    @NotEmpty
    public static final String CONTEXT = "context";
    @Nonnull
    @NotEmpty
    public static final String KEY = "key";
    @Nonnull
    @NotEmpty
    public static final String VALUE = "value";
    @Nonnull
    @NotEmpty
    public static final String EXP = "exp";
    @Nonnull
    @NotEmpty
    public static final String VERSION = "version";
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DoStorageOperation.class);
    @NonnullAfterInit
    private StorageService storageService;
    @NonnullBeforeExec
    private DDF input;

    public void setStorageService(@Nonnull StorageService storage) {
        this.checkSetterPreconditions();
        this.storageService = (StorageService)Constraint.isNotNull((Object)storage, (String)"StorageService cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.storageService == null) {
            throw new ComponentInitializationException("StorageService cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.input = this.ensureAgentRequestContext().getInput();
        if (this.input == null || !this.input.isstruct()) {
            this.log.warn("{} Invalid or missing input message", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        try {
            String op = this.input.getmember(OP).string();
            if ("C".equals(op)) {
                this.doCreate(profileRequestContext);
            } else if ("R".equals(op)) {
                this.doRead(profileRequestContext);
            } else if ("U".equals(op)) {
                this.doUpdate(profileRequestContext);
            } else if ("D".equals(op)) {
                this.doDelete(profileRequestContext);
            } else {
                this.log.warn("{} Invalid operation: {}", (Object)this.getLogPrefix(), (Object)op);
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            }
        }
        catch (IOException e) {
            this.log.error("{} I/O error responding to request", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
        }
    }

    private void doCreate(@Nonnull ProfileRequestContext profileRequestContext) throws IOException {
        Object context = this.input.getmember(CONTEXT).string();
        String key = this.input.getmember(KEY).string();
        String value = this.input.getmember(VALUE).string();
        if (context == null || key == null || value == null) {
            this.log.warn("{} Context, key, and, value are required for create operation", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
        context = this.ensureAgent().getId() + "!" + (String)context;
        Long exp = this.input.getmember(EXP).longinteger();
        if (exp != null) {
            exp = exp * 1000L;
        }
        if (this.storageService.create((String)context, key, value, exp)) {
            this.log.trace("{} Created record with context ({}), key ({}), expiration ({})", new Object[]{this.getLogPrefix(), context, key, exp});
        } else {
            this.log.warn("{} Record exists with context ({}), key ({})", new Object[]{this.getLogPrefix(), context, key});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)DUPLICATE_RECORD);
        }
    }

    private void doRead(@Nonnull ProfileRequestContext profileRequestContext) throws IOException {
        Object context = this.input.getmember(CONTEXT).string();
        String key = this.input.getmember(KEY).string();
        if (context == null || key == null) {
            this.log.warn("{} Context and key are required for read operation", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
        context = this.ensureAgent().getId() + "!" + (String)context;
        StorageRecord record = this.storageService.read((String)context, key);
        if (record != null) {
            DDF output = new DDF().structure();
            output.addmember(VALUE).string(record.getValue());
            output.addmember(VERSION).longinteger(record.getVersion());
            Long exp = record.getExpiration();
            if (exp != null) {
                output.addmember(EXP).longinteger(exp / 1000L);
            }
            this.ensureAgentRequestContext().setOutput(output);
        } else {
            this.log.trace("{} No record found with context ({}), key ({})", new Object[]{this.getLogPrefix(), context, key});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)RECORD_NOT_FOUND);
        }
    }

    private void doUpdate(@Nonnull ProfileRequestContext profileRequestContext) throws IOException {
        block13: {
            Object context = this.input.getmember(CONTEXT).string();
            String key = this.input.getmember(KEY).string();
            String value = this.input.getmember(VALUE).string();
            Long exp = this.input.getmember(EXP).longinteger();
            if (context == null || key == null) {
                this.log.warn("{} Context and key are required for update operation", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
                return;
            }
            if (value == null && exp == null) {
                this.log.warn("{} Either value or expiration must be provided for update operation", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
                return;
            }
            context = this.ensureAgent().getId() + "!" + (String)context;
            if (exp != null) {
                exp = exp * 1000L;
            }
            if (value == null) {
                if (this.storageService.updateExpiration((String)context, key, exp)) {
                    this.log.trace("{} Updated expiration for context ({}), key ({})", new Object[]{this.getLogPrefix(), context, key});
                    DDF output = new DDF().structure();
                    this.ensureAgentRequestContext().setOutput(output);
                } else {
                    this.log.info("{} No record to update expiration with context ({}), key ({})", new Object[]{this.getLogPrefix(), context, key});
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)RECORD_NOT_FOUND);
                }
                return;
            }
            Long version = this.input.getmember(VERSION).longinteger();
            if (version != null) {
                try {
                    version = this.storageService.updateWithVersion(version.longValue(), (String)context, key, value, exp);
                    if (version != null) {
                        this.log.trace("{} Updated record with context ({}), key ({}), version ({})", new Object[]{this.getLogPrefix(), context, key, version});
                        DDF output = new DDF().structure();
                        output.addmember(VERSION).longinteger(version.longValue());
                        this.ensureAgentRequestContext().setOutput(output);
                        break block13;
                    }
                    this.log.info("{} No record to update with context ({}), key ({})", new Object[]{this.getLogPrefix(), context, key});
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)RECORD_NOT_FOUND);
                }
                catch (VersionMismatchException e) {
                    this.log.info("{} Existing record with context ({}), key ({}). but version ({})", new Object[]{this.getLogPrefix(), context, key, version});
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)VERSION_MISMATCH);
                }
            } else if (this.storageService.update((String)context, key, value, exp)) {
                this.log.trace("{} Updated record with context ({}), key ({}), expiration ({})", new Object[]{this.getLogPrefix(), context, key, exp});
            } else {
                this.log.warn("{} No record to update with context ({}), key ({})", new Object[]{this.getLogPrefix(), context, key});
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
            }
        }
    }

    private void doDelete(@Nonnull ProfileRequestContext profileRequestContext) throws IOException {
        Object context = this.input.getmember(CONTEXT).string();
        String key = this.input.getmember(KEY).string();
        if (context == null || key == null) {
            this.log.warn("{} Context and key are required for delete operation", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
        context = this.ensureAgent().getId() + "!" + (String)context;
        if (this.storageService.delete((String)context, key)) {
            this.log.trace("{} Deleted record with context ({}), key ({})", new Object[]{this.getLogPrefix(), context, key});
        } else {
            this.log.trace("{} No record to delete with context ({}), key ({})", new Object[]{this.getLogPrefix(), context, key});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)RECORD_NOT_FOUND);
        }
    }
}

