/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.profile.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.time.Instant;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.Positive;
import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.codec.DecodingException;
import net.shibboleth.shared.codec.EncodingException;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import net.shibboleth.sp.ddf.DDF;
import net.shibboleth.sp.profile.AbstractAgentAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageService;
import org.opensaml.storage.VersionMismatchException;
import org.slf4j.Logger;

public class DoSessionCacheOperation
extends AbstractAgentAction {
    @Nonnull
    @NotEmpty
    public static final String STORAGE_CONTEXT = "net.shibboleth.sp.sessions";
    @Nonnull
    @NotEmpty
    public static final String INVALID_SESSION = "InvalidSession";
    @Nonnull
    @NotEmpty
    public static final String MISSING_SESSION = "MissingSession";
    @Nonnull
    @NotEmpty
    public static final String EXPIRED_SESSION = "ExpiredSession";
    @Nonnull
    @NotEmpty
    public static final String VERSION_MISMATCH = "VersionMismatch";
    @Nonnull
    @NotEmpty
    public static final String OP = "op";
    @Nonnull
    @NotEmpty
    public static final String SESSION = "session";
    @Nonnull
    @NotEmpty
    public static final String STORAGE_TIMEOUT = "storage_timeout";
    @Nonnull
    @NotEmpty
    public static final String KEY = "key";
    @Nonnull
    @NotEmpty
    public static final String LIFETIME = "lifetime";
    @Nonnull
    @NotEmpty
    public static final String TIMEOUT = "timeout";
    @Nonnull
    @NotEmpty
    public static final String VERSION = "ver";
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DoSessionCacheOperation.class);
    @NonnullAfterInit
    private StorageService storageService;
    @NonnullAfterInit
    private IdentifierGenerationStrategy identifierStrategy;
    @Nonnull
    private Duration maxStorageTimeout = Duration.ofDays(1L);
    @NonnullBeforeExec
    private DDF input;

    public void setStorageService(@Nonnull StorageService storage) {
        this.checkSetterPreconditions();
        this.storageService = (StorageService)Constraint.isNotNull((Object)storage, (String)"StorageService cannot be null");
    }

    public void setIdentifierGenerationStrategy(@Nonnull IdentifierGenerationStrategy strategy) {
        this.checkSetterPreconditions();
        this.identifierStrategy = (IdentifierGenerationStrategy)Constraint.isNotNull((Object)strategy, (String)"IdentifierGenerationStrategy cannot be null");
    }

    public void setMaxStorageTimeout(@Nonnull @Positive Duration timeout) {
        Constraint.isFalse((timeout == null || timeout.isZero() || timeout.isNegative() ? 1 : 0) != 0, (String)"Max storage timeout must be positive");
        this.maxStorageTimeout = timeout;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.storageService == null) {
            throw new ComponentInitializationException("StorageService cannot be null");
        }
        if (this.identifierStrategy == null) {
            this.identifierStrategy = IdentifierGenerationStrategy.getInstance((IdentifierGenerationStrategy.ProviderType)IdentifierGenerationStrategy.ProviderType.SECURE);
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.input = this.ensureAgentRequestContext().getInput();
        if (this.input == null || !this.input.isstruct()) {
            this.log.warn("{} Invalid or missing input message", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        try {
            String op = this.input.getmember(OP).string();
            if ("C".equals(op)) {
                this.doCreate(profileRequestContext);
            } else if ("R".equals(op)) {
                this.doRead(profileRequestContext);
            } else if ("U".equals(op)) {
                this.doUpdate(profileRequestContext);
            } else if ("T".equals(op)) {
                this.doTouch(profileRequestContext);
            } else if ("D".equals(op)) {
                this.doDelete(profileRequestContext);
            } else {
                this.log.warn("{} Invalid operation: {}", (Object)this.getLogPrefix(), (Object)op);
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            }
        }
        catch (IOException e) {
            this.log.error("{} I/O error responding to request", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
        }
    }

    private void doCreate(@Nonnull ProfileRequestContext profileRequestContext) throws IOException {
        String value;
        DDF data = this.input.getmember(SESSION);
        if (!data.isstruct()) {
            this.log.warn("{} Missing required '{}' structure member", (Object)this.getLogPrefix(), (Object)SESSION);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
        Long exp = Instant.now().plusSeconds(this.getStorageTimeout()).toEpochMilli();
        try (ByteArrayOutputStream sink = new ByteArrayOutputStream();){
            data.serialize((OutputStream)sink);
            value = Base64Support.encode((byte[])sink.toByteArray(), (boolean)false);
        }
        catch (EncodingException e) {
            this.log.error("{} Unable to base64-encode session data", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToEncode");
            return;
        }
        int attempts = 0;
        do {
            String key = this.identifierStrategy.generateIdentifier(false);
            if (this.storageService.create(this.getStorageContext(), key, value, exp)) {
                this.log.debug("{} Created session record ({}), expiration ({})", new Object[]{this.getLogPrefix(), key, Instant.ofEpochMilli(exp)});
                DDF out = new DDF(null);
                out.addmember(KEY).string(key);
                this.ensureAgentRequestContext().setOutput(out);
                return;
            }
            this.log.warn("{} Session record ({}) exists", (Object)this.getLogPrefix(), (Object)key);
        } while (++attempts < 3);
        this.log.warn("{} Unable to generate usable session key after 3 attempts", (Object)this.getLogPrefix());
        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"MessageProcessingError");
    }

    private void doRead(@Nonnull ProfileRequestContext profileRequestContext) throws IOException {
        DDF sessionData;
        String key = this.input.getmember(KEY).string();
        if (key == null) {
            this.log.warn("{} Missing required '{}' structure member", (Object)this.getLogPrefix(), (Object)KEY);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
        StorageRecord record = this.storageService.read(this.getStorageContext(), key);
        if (record == null) {
            this.log.debug("{} No session found ({})", (Object)this.getLogPrefix(), (Object)key);
            return;
        }
        Long lastAccess = record.getExpiration();
        if (lastAccess == null) {
            this.log.error("{} Session record ({}) had no expiration", (Object)this.getLogPrefix(), (Object)key);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)INVALID_SESSION);
            return;
        }
        Instant now = Instant.now();
        Integer timeout = this.input.getmember(TIMEOUT).integer();
        if (timeout != null && timeout > 0 && Instant.ofEpochMilli(lastAccess = Long.valueOf(lastAccess - this.getStorageTimeout() * 1000L)).plusSeconds(timeout.intValue()).isBefore(now)) {
            this.log.info("{} Session record ({}) timed out, last use was {}, timeout policy was {}", new Object[]{this.getLogPrefix(), key, Instant.ofEpochMilli(lastAccess), timeout});
            this.storageService.delete(this.getStorageContext(), key);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)EXPIRED_SESSION);
            return;
        }
        try (ByteArrayInputStream source = new ByteArrayInputStream(Base64Support.decode((String)record.getValue()));){
            sessionData = DDF.deserialize((InputStream)source);
        }
        catch (DecodingException e) {
            this.log.error("{} Unable to base64-decode session data", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)INVALID_SESSION);
            return;
        }
        catch (IOException e) {
            this.log.error("{} Unable to deserialize session record", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)INVALID_SESSION);
            return;
        }
        DDF output = new DDF().structure();
        sessionData.name(SESSION);
        output.add(sessionData);
        this.ensureAgentRequestContext().setOutput(output);
    }

    private void doUpdate(@Nonnull ProfileRequestContext profileRequestContext) throws IOException {
        String value;
        String key = this.input.getmember(KEY).string();
        Integer version = this.input.getmember(VERSION).integer();
        if (key == null || version == null || version <= 0) {
            this.log.warn("{} Missing required '{}' or '{}' structure member", new Object[]{this.getLogPrefix(), KEY, VERSION});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
        DDF data = this.input.getmember(SESSION);
        if (!data.isstruct()) {
            this.log.warn("{} Missing required '{}' structure member", (Object)this.getLogPrefix(), (Object)SESSION);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
        Long st = this.getStorageTimeout();
        Long exp = Instant.now().plusSeconds(st).toEpochMilli();
        try (ByteArrayOutputStream sink = new ByteArrayOutputStream();){
            data.serialize((OutputStream)sink);
            value = Base64Support.encode((byte[])sink.toByteArray(), (boolean)false);
        }
        catch (EncodingException e) {
            this.log.error("{} Unable to base64-encode session data", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToEncode");
            return;
        }
        try {
            Long newver = this.storageService.updateWithVersion((long)version.intValue(), this.getStorageContext(), key, value, exp);
            if (newver != null) {
                this.log.debug("{} Updated session ({}) to version ({})", new Object[]{this.getLogPrefix(), key, version});
                DDF output = new DDF().structure();
                output.addmember(VERSION).integer(newver.intValue());
                this.ensureAgentRequestContext().setOutput(output);
            } else {
                this.log.debug("{} No session found ({})", (Object)this.getLogPrefix(), (Object)key);
            }
        }
        catch (VersionMismatchException e) {
            this.log.info("{} Version mismatch for session ({}). requested update with non-matching version ({})", new Object[]{this.getLogPrefix(), key, version});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)VERSION_MISMATCH);
        }
    }

    private void doTouch(@Nonnull ProfileRequestContext profileRequestContext) throws IOException {
        String key = this.input.getmember(KEY).string();
        if (key == null) {
            this.log.warn("{} Missing required '{}' structure member", (Object)this.getLogPrefix(), (Object)KEY);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
        Instant now = Instant.now();
        Long st = this.getStorageTimeout();
        Integer timeout = this.input.getmember(TIMEOUT).integer();
        if (timeout != null && timeout > 0) {
            StorageRecord record = this.storageService.read(this.getStorageContext(), key);
            if (record == null) {
                this.log.debug("{} No session found ({})", (Object)this.getLogPrefix(), (Object)key);
                return;
            }
            Long lastAccess = record.getExpiration();
            if (lastAccess == null) {
                this.log.error("{} Session record ({}) had no expiration", (Object)this.getLogPrefix(), (Object)key);
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)INVALID_SESSION);
                return;
            }
            if (Instant.ofEpochMilli(lastAccess = Long.valueOf(lastAccess - st * 1000L)).plusSeconds(timeout.intValue()).isBefore(now)) {
                this.log.info("{} Session record ({}) timed out, last use was {}, timeout policy was {}", new Object[]{this.getLogPrefix(), key, Instant.ofEpochMilli(lastAccess), timeout});
                this.storageService.delete(this.getStorageContext(), key);
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)EXPIRED_SESSION);
                return;
            }
        }
        if (!this.storageService.updateExpiration(this.getStorageContext(), key, Long.valueOf(now.plusSeconds(st).toEpochMilli()))) {
            this.log.debug("{} Session record ({}) disappeared before update?", (Object)this.getLogPrefix(), (Object)key);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)MISSING_SESSION);
        }
    }

    private void doDelete(@Nonnull ProfileRequestContext profileRequestContext) throws IOException {
        String key = this.input.getmember(KEY).string();
        if (key == null) {
            this.log.warn("{} Key required for delete operation", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
        if (this.storageService.delete(this.getStorageContext(), key)) {
            this.log.debug("{} Deleted session record ({})", (Object)this.getLogPrefix(), (Object)key);
        } else {
            this.log.debug("{} No session record ({})", (Object)this.getLogPrefix(), (Object)key);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)MISSING_SESSION);
        }
    }

    @Nonnull
    private Long getStorageTimeout() {
        Long st = this.input.getmember(STORAGE_TIMEOUT).longinteger();
        if (st != null) {
            if (st <= this.maxStorageTimeout.toSeconds()) {
                return st;
            }
            this.log.warn("{} Agent-supplied {} value exceeded configured maximum ({})", new Object[]{this.getLogPrefix(), STORAGE_TIMEOUT, this.maxStorageTimeout});
        }
        return this.maxStorageTimeout.toSeconds();
    }

    @Nonnull
    private String getStorageContext() {
        return "net.shibboleth.sp.sessions!" + this.ensureAgent().getId();
    }
}

