/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.impl;

import java.io.IOException;
import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.codec.DecodingException;
import net.shibboleth.shared.codec.EncodingException;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.sp.Agent;
import net.shibboleth.sp.Application;
import net.shibboleth.sp.profile.AbstractStateTokenManager;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageService;
import org.slf4j.Logger;

public class StorageServiceStateTokenManager
extends AbstractStateTokenManager {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(StorageServiceStateTokenManager.class);
    @NonnullAfterInit
    private StorageService storageService;

    public void setStorageService(@Nonnull StorageService storage) {
        this.checkSetterPreconditions();
        this.storageService = (StorageService)Constraint.isNotNull((Object)storage, (String)"StorageService cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.storageService == null) {
            throw new ComponentInitializationException("StorageService cannot be null");
        }
        if (!this.storageService.getCapabilities().isServerSide()) {
            throw new ComponentInitializationException("StorageService cannot be client-side");
        }
    }

    @Nonnull
    public String preserveToStateToken(@Nonnull Agent agent, @Nonnull Application application, @Nonnull byte[] value) throws IOException {
        String encoded;
        String context = this.getContext(agent, application);
        String key = this.generateToken();
        try {
            encoded = Base64Support.encode((byte[])value, (boolean)false);
        }
        catch (EncodingException e) {
            throw new IOException(e);
        }
        if (this.storageService.create(context, key, encoded, Long.valueOf(Instant.now().plus(this.getExpiration()).toEpochMilli()))) {
            this.log.trace("Created state token mapping ('{}', '{}') to value '{}'", new Object[]{context, key, encoded});
            return key;
        }
        throw new IOException("Unable to create storage record for state token");
    }

    @Nullable
    public byte[] recoverFromStateToken(@Nonnull Agent agent, @Nonnull Application application, @Nonnull String token) throws IOException {
        String context = this.getContext(agent, application);
        StorageRecord record = this.storageService.read(context, token);
        if (record != null) {
            this.log.trace("Recovered state token mapping ('{}', '{}') to value '{}'", new Object[]{context, token, record.getValue()});
            try {
                this.storageService.delete(context, token);
            }
            catch (IOException e) {
                this.log.warn("Unable to delete state token ('{}', '{}') from storage", new Object[]{context, token, e});
            }
            try {
                return Base64Support.decode((String)record.getValue());
            }
            catch (DecodingException e) {
                throw new IOException(e);
            }
        }
        return null;
    }

    @Nonnull
    private String getContext(@Nonnull Agent agent, @Nonnull Application application) {
        StringBuilder builder = new StringBuilder(StorageServiceStateTokenManager.class.getName());
        builder.append('!').append(agent.getId()).append('!').append(application.getId());
        return builder.toString();
    }
}

