/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.impl;

import com.google.common.base.Functions;
import com.google.common.base.MoreObjects;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonNegative;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.component.IdentifiedComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.net.IPRange;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.sp.Agent;
import net.shibboleth.sp.Application;
import net.shibboleth.sp.impl.BasicApplication;

public class BasicAgent
extends BasicApplication
implements Agent {
    private boolean supportsCachedAuthentication = true;
    @Nonnull
    private Set<IPRange> allowedAddressRanges = CollectionSupport.emptySet();
    @Nullable
    @NotEmpty
    String authenticationMethod = null;
    private boolean supportsPostPreservation = false;
    private long postLimit = 0x100000L;
    @Nonnull
    private Charset encoding = StandardCharsets.UTF_8;
    @Nonnull
    private Map<String, String> credentials = CollectionSupport.emptyMap();
    @Nonnull
    private Map<String, Application> applicationMap = CollectionSupport.emptyMap();

    public BasicAgent() {
        this.setAllowInheritance(false);
    }

    @Override
    @Nonnull
    @NotEmpty
    public String getApplicationId() {
        return "default";
    }

    @Nonnull
    public Set<IPRange> getAllowedAddressRanges() {
        return this.allowedAddressRanges;
    }

    public void setAllowedAddressRanges(@Nullable Set<IPRange> ranges) {
        this.checkSetterPreconditions();
        this.allowedAddressRanges = ranges != null ? CollectionSupport.copyToSet(ranges) : CollectionSupport.emptySet();
    }

    public boolean isAllowed(@Nonnull InetAddress address) {
        this.checkComponentActive();
        return this.allowedAddressRanges.stream().anyMatch(r -> r.contains(address));
    }

    @Nullable
    @NotEmpty
    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setAuthenticationMethod(@Nullable @NotEmpty String method) {
        this.checkSetterPreconditions();
        String trimmed = StringSupport.trimOrNull((String)method);
        Constraint.isTrue((trimmed == null || "basic".equals(trimmed) ? 1 : 0) != 0, (String)"Unsupported authentication method");
        this.authenticationMethod = trimmed;
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public Map<String, String> getCredentials() {
        return this.credentials;
    }

    public void setCredentials(@Nullable Map<String, String> creds) {
        this.checkSetterPreconditions();
        this.credentials = creds != null ? new HashMap<String, String>(creds) : CollectionSupport.emptyMap();
    }

    public void setUsernames(@Nullable Collection<String> usernames) {
        this.checkSetterPreconditions();
        if (usernames != null) {
            this.credentials = new HashMap<String, String>(usernames.size());
            for (String username : usernames) {
                this.credentials.put(username, null);
            }
        } else {
            this.credentials = CollectionSupport.emptyMap();
        }
    }

    public boolean isSupportsCachedAuthentication() {
        return this.supportsCachedAuthentication;
    }

    public void setSupportsCachedAuthentication(boolean flag) {
        this.checkSetterPreconditions();
        this.supportsCachedAuthentication = flag;
    }

    public boolean isSupportsPostPreservation() {
        return this.supportsPostPreservation;
    }

    public void setSupportsPostPreservation(boolean flag) {
        this.checkSetterPreconditions();
        this.supportsPostPreservation = flag;
    }

    public long getPostLimit() {
        return this.postLimit;
    }

    public void setPostLimit(@NonNegative long limit) {
        this.checkSetterPreconditions();
        this.postLimit = Constraint.isGreaterThanOrEqual((long)0L, (long)limit, (String)"Post limit cannot be negative.");
    }

    @Nonnull
    public Charset getCharacterEncoding() {
        return this.encoding;
    }

    public void CharacterEncoding(@Nonnull String name) {
        this.encoding = Charset.forName(name);
    }

    public void setApplications(@Nullable Set<Application> applications) {
        this.checkSetterPreconditions();
        this.applicationMap = applications != null ? (Map)((NonnullSupplier)applications.stream().collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableMap(IdentifiedComponent::getId, Functions.identity())))).get() : CollectionSupport.emptyMap();
    }

    @Nullable
    public Application getApplication(@Nonnull String id) {
        this.checkComponentActive();
        if ("default".equals(id)) {
            return this;
        }
        return this.applicationMap.get(id);
    }

    @Nonnull
    public Collection<Application> getApplications() {
        this.checkComponentActive();
        ArrayList<Application> apps = new ArrayList<Application>(this.applicationMap.size() + 1);
        apps.add(this);
        apps.addAll(this.applicationMap.values());
        return CollectionSupport.copyToList(apps);
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.ensureId().contains("!")) {
            throw new ComponentInitializationException("Agent ID cannot contain bang character (!)");
        }
        for (Application a : this.applicationMap.values()) {
            if (!(a instanceof BasicApplication)) continue;
            BasicApplication app = (BasicApplication)a;
            app.setParent(this);
        }
    }

    @Override
    public int hashCode() {
        return this.getId().hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Agent)) return false;
        Agent agent = (Agent)obj;
        if (!Objects.equals(this.getId(), agent.getId())) return false;
        return true;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).toString();
    }
}

