/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.authn.impl;

import com.google.common.net.InetAddresses;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.net.InetAddress;
import javax.annotation.Nonnull;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.servlet.HttpServletSupport;
import net.shibboleth.sp.Agent;
import net.shibboleth.sp.profile.AbstractAgentAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ValidateAgentAddress
extends AbstractAgentAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ValidateAgentAddress.class);

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        Agent agent = this.ensureAgent();
        HttpServletRequest request = this.getHttpServletRequest();
        if (request == null) {
            this.log.warn("{} Request denied from agent '{}', no servlet request available", (Object)this.getLogPrefix(), (Object)agent.getId());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"AccessDenied");
            return;
        }
        String s = HttpServletSupport.getRemoteAddr((ServletRequest)request);
        try {
            InetAddress addr;
            InetAddress inetAddress = addr = s != null ? InetAddresses.forString((String)s) : null;
            if (addr == null) {
                throw new IllegalArgumentException("Client address unavailable.");
            }
            if (agent.isAllowed(addr)) {
                this.log.debug("{} Request permitted from agent '{}' from {}", new Object[]{this.getLogPrefix(), agent.getId(), s});
            } else {
                this.log.warn("{} Request denied from agent '{}' from {}", new Object[]{this.getLogPrefix(), agent.getId(), s});
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"AccessDenied");
            }
        }
        catch (IllegalArgumentException e) {
            this.log.warn("{} Request denied from agent '{}'", new Object[]{this.getLogPrefix(), agent.getId(), e});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"AccessDenied");
        }
    }
}

