/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.authn.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.UsernamePasswordContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import net.shibboleth.shared.resolver.ResolverException;
import net.shibboleth.shared.service.ReloadableService;
import net.shibboleth.shared.service.ServiceException;
import net.shibboleth.shared.service.ServiceableComponent;
import net.shibboleth.sp.Agent;
import net.shibboleth.sp.AgentCriterion;
import net.shibboleth.sp.AgentResolver;
import net.shibboleth.sp.context.AgentRequestContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class InitializeAgentRequestContext
extends AbstractAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(InitializeAgentRequestContext.class);
    @Nonnull
    private Function<ProfileRequestContext, UsernamePasswordContext> usernamePasswordContextLookupStrategy = new ChildContextLookup(UsernamePasswordContext.class).compose((Function)new ChildContextLookup(AuthenticationContext.class));
    @Nonnull
    private Function<ProfileRequestContext, AgentRequestContext> agentRequestContextCreationStrategy = new ChildContextLookup(AgentRequestContext.class, true);
    @NonnullAfterInit
    ReloadableService<AgentResolver> agentResolver;
    @NonnullBeforeExec
    private String agentCredentialID;

    public void setUsernamePasswordContextLookupStrategy(@Nonnull Function<ProfileRequestContext, UsernamePasswordContext> strategy) {
        this.checkSetterPreconditions();
        this.usernamePasswordContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"UsernamePasswordContext lookup strategy cannot be null");
    }

    public void setAgentRequestContextCreationStrategy(@Nonnull Function<ProfileRequestContext, AgentRequestContext> strategy) {
        this.checkSetterPreconditions();
        this.agentRequestContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"AgentRequestContext creation strategy cannot be null");
    }

    public void setAgentResolver(@Nonnull ReloadableService<AgentResolver> service) {
        this.checkSetterPreconditions();
        this.agentResolver = (ReloadableService)Constraint.isNotNull(service, (String)"AgentResolver service cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.agentResolver == null) {
            throw new ComponentInitializationException("AgentResolver service cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        UsernamePasswordContext usernamePasswordContext = this.usernamePasswordContextLookupStrategy.apply(profileRequestContext);
        if (usernamePasswordContext != null) {
            this.agentCredentialID = usernamePasswordContext.getUsername();
        }
        if (this.agentCredentialID == null) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnknownUsername");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        try (ServiceableComponent resolver = this.agentResolver.getServiceableComponent();){
            Agent agent = (Agent)((AgentResolver)resolver.getComponent()).resolveSingle((Object)new CriteriaSet(new Criterion[]{new AgentCriterion(this.agentCredentialID)}));
            if (agent == null) {
                this.log.warn("{} Unknown agent based on credential ID: '{}'", (Object)this.getLogPrefix(), (Object)this.agentCredentialID);
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnknownUsername");
                return;
            }
            AgentRequestContext agentRequestContext = this.agentRequestContextCreationStrategy.apply(profileRequestContext);
            if (agentRequestContext == null) {
                this.log.error("{} Unable to create AgentRequestContext", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
                return;
            }
            agentRequestContext.setAgent(agent);
        }
        catch (ServiceException e) {
            this.log.error("{} Unable to obtain AgentResolver component", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
        }
        catch (ResolverException e) {
            this.log.error("{} Error resolving Agent '{}'", new Object[]{this.getLogPrefix(), this.agentCredentialID, e});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
        }
    }
}

