/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.authn.impl;

import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import net.shibboleth.idp.authn.AbstractUsernamePasswordCredentialValidator;
import net.shibboleth.idp.authn.CredentialValidator;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.UsernamePasswordContext;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.sp.Agent;
import net.shibboleth.sp.context.AgentRequestContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class AgentSecretCredentialValidator
extends AbstractUsernamePasswordCredentialValidator {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AgentSecretCredentialValidator.class);
    @Nonnull
    private Function<ProfileRequestContext, AgentRequestContext> agentRequestContextLookupStrategy = new ChildContextLookup(AgentRequestContext.class);
    @NonnullBeforeExec
    private Agent agent;

    public void setAgentRequestContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AgentRequestContext> strategy) {
        this.checkSetterPreconditions();
        this.agentRequestContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AgentRequestContext lookup strategy cannot be null");
    }

    @Nullable
    protected Subject doValidate(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nonnull UsernamePasswordContext usernamePasswordContext, @Nullable CredentialValidator.WarningHandler warningHandler, @Nullable CredentialValidator.ErrorHandler errorHandler) throws Exception {
        Agent agent;
        AgentRequestContext agentContext = this.agentRequestContextLookupStrategy.apply(profileRequestContext);
        Agent agent2 = agent = agentContext != null ? agentContext.getAgent() : null;
        if (agent == null) {
            this.log.error("{} Agent missing from request context", (Object)this.getLogPrefix());
            LoginException e = new LoginException("InvalidProfileContext");
            if (errorHandler != null) {
                errorHandler.handleError(profileRequestContext, authenticationContext, (Exception)e, "InvalidProfileContext");
            }
            throw e;
        }
        Map credentials = agent.getCredentials();
        if (credentials.isEmpty()) {
            this.log.debug("{} No shared secrets configured locally for agent '{}', ignoring", (Object)this.getLogPrefix(), (Object)agent.getId());
            return null;
        }
        this.log.debug("{} Attempting to authenticate agent '{}' with username '{}'", new Object[]{this.getLogPrefix(), agent.getId(), usernamePasswordContext.getUsername()});
        for (Map.Entry candidate : credentials.entrySet()) {
            if (candidate.getValue() == null || !((String)Constraint.isNotNull((Object)usernamePasswordContext.getUsername(), (String)"Username was null")).equals(candidate.getKey() != null ? candidate.getKey() : agent.getId()) || !((String)Constraint.isNotNull((Object)usernamePasswordContext.getPassword(), (String)"Password was null")).equals(candidate.getValue())) continue;
            this.log.info("{} Authentication of agent '{}' with username '{}' succeeded", new Object[]{this.getLogPrefix(), agent.getId(), candidate.getKey()});
            return this.populateSubject(new Subject(), usernamePasswordContext);
        }
        this.log.info("{} Authentication of agent '{}' failed", (Object)this.getLogPrefix(), (Object)agent.getId());
        LoginException e = new LoginException("InvalidCredentials");
        if (errorHandler != null) {
            errorHandler.handleError(profileRequestContext, authenticationContext, (Exception)e, "InvalidCredentials");
        }
        throw e;
    }
}

