/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.profile.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.IdentifiedComponent;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.sp.messaging.RemotedHttpServletRequest;
import net.shibboleth.sp.messaging.RemotedHttpServletRequestResponseContext;
import net.shibboleth.sp.messaging.RemotedHttpServletResponse;
import net.shibboleth.sp.profile.AbstractApplicationAction;
import net.shibboleth.sp.profile.TokenConsumerFlowDescriptor;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class SelectTokenConsumerFlow
extends AbstractApplicationAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SelectTokenConsumerFlow.class);
    @Nonnull
    private Map<String, TokenConsumerFlowDescriptor> availableFlows = CollectionSupport.emptyMap();

    public void setAvailableFlows(@Nonnull Collection<TokenConsumerFlowDescriptor> flows) {
        this.checkSetterPreconditions();
        this.availableFlows = (Map)((NonnullSupplier)flows.stream().collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableMap(IdentifiedComponent::getId, Function.identity())))).get();
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (this.ensureAgentRequestContext().getRemotedHttpServletRequest() == null) {
            this.log.warn("No remoted HttpServletRequest available, malformed agent request?", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoPotentialFlow");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        try {
            RemotedHttpServletRequestResponseContext.loadCurrent((RemotedHttpServletRequest)this.ensureAgentRequestContext().getRemotedHttpServletRequest(), (RemotedHttpServletResponse)this.ensureAgentRequestContext().getRemotedHttpServletResponse());
            List flows = this.ensureApplication().getTokenConsumers(profileRequestContext);
            for (String flowId : flows) {
                assert (flowId != null);
                TokenConsumerFlowDescriptor flowDescriptor = this.availableFlows.get("sp/consumer/" + flowId);
                if (flowDescriptor != null) {
                    if (flowDescriptor.getActivationCondition().test(profileRequestContext)) {
                        this.log.debug("{} Token consumer flow {} handling request", (Object)this.getLogPrefix(), (Object)flowId);
                        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)("sp/consumer/" + flowId));
                        return;
                    }
                    this.log.debug("{} Token consumer flow {} cannot handle request", (Object)this.getLogPrefix(), (Object)flowId);
                    continue;
                }
                this.log.warn("{} Token consumer flow {} is not available", (Object)this.getLogPrefix(), (Object)flowId);
            }
        }
        finally {
            RemotedHttpServletRequestResponseContext.clearCurrent();
        }
        this.log.warn("{} No token consumer flows were able to handle request", (Object)this.getLogPrefix());
        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoPotentialFlow");
    }
}

