/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.profile.impl;

import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.sp.Agent;
import net.shibboleth.sp.Application;
import net.shibboleth.sp.ddf.DDF;
import net.shibboleth.sp.profile.AbstractAgentAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ResolveApplication
extends AbstractAgentAction {
    @Nonnull
    @NotEmpty
    public static final String APPLICATION_ID = "application";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ResolveApplication.class);

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        String applicationId;
        Agent agent = this.ensureAgent();
        DDF input = this.ensureAgentRequestContext().getInput();
        String string = applicationId = input != null ? input.getmember(APPLICATION_ID).string() : null;
        if (applicationId == null) {
            this.log.warn("{} Request from agent '{}' missing {} specifier", new Object[]{this.getLogPrefix(), agent.getId(), APPLICATION_ID});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
        Application app = agent.getApplication(applicationId);
        if (app != null) {
            this.log.debug("{} Request from agent '{}' mapped to application '{}'", new Object[]{this.getLogPrefix(), agent.getId(), app.getId()});
            this.ensureAgentRequestContext().setApplication(app);
        } else {
            this.log.warn("{} Request from agent '{}' with unknown application '{}'", new Object[]{this.getLogPrefix(), agent.getId(), applicationId});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
        }
    }
}

