/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.profile.impl;

import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.codec.HTMLEncoder;
import net.shibboleth.shared.codec.StringDigester;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.net.CookieManager;
import net.shibboleth.shared.net.URISupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import net.shibboleth.shared.servlet.HttpServletSupport;
import net.shibboleth.sp.context.AgentRequestContext;
import net.shibboleth.sp.ddf.DDF;
import net.shibboleth.sp.messaging.RemotedHttpServletRequest;
import net.shibboleth.sp.messaging.RemotedHttpServletRequestResponseContext;
import net.shibboleth.sp.messaging.RemotedHttpServletResponse;
import net.shibboleth.sp.profile.AbstractApplicationAction;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageService;
import org.slf4j.Logger;

public class RecoverPostData
extends AbstractApplicationAction {
    @Nonnull
    @NotEmpty
    public static final String DEFAULT_TEMPLATE_ID = "/templates/sp/post-replay.vm";
    @Nonnull
    @NotEmpty
    public static final String DEFAULT_COOKIE_PREFIX = "_shibsp_post_";
    @Nonnull
    private Logger log = LoggerFactory.getLogger(RecoverPostData.class);
    @NonnullAfterInit
    private VelocityEngine velocityEngine;
    @NonnullAfterInit
    private String velocityTemplateId = "/templates/sp/post-replay.vm";
    @Nullable
    private StringDigester cspDigester;
    @Nullable
    private IdentifierGenerationStrategy cspNonceGenerator;
    @NonnullAfterInit
    private StorageService storageService;
    @NonnullAfterInit
    private CookieManager cookieManager;
    @Nonnull
    private String cookiePrefix = "_shibsp_post_";
    @NonnullBeforeExec
    private CharsetDecoder decoder;
    @NonnullBeforeExec
    private String postData;

    public RecoverPostData() {
        this.setCreateOutputObjects(true);
    }

    public void setVelocityEngine(@Nullable VelocityEngine newVelocityEngine) {
        this.checkSetterPreconditions();
        this.velocityEngine = newVelocityEngine;
    }

    public void setVelocityTemplateId(@Nullable String newVelocityTemplateId) {
        this.checkSetterPreconditions();
        this.velocityTemplateId = newVelocityTemplateId;
    }

    public void setCSPDigester(@Nullable StringDigester digester) {
        this.checkSetterPreconditions();
        this.cspDigester = digester;
    }

    public void setCSPNonceGenerator(@Nullable IdentifierGenerationStrategy strategy) {
        this.checkSetterPreconditions();
        this.cspNonceGenerator = (IdentifierGenerationStrategy)Constraint.isNotNull((Object)strategy, (String)"IdentifierGenerationStrategy cannot be null");
    }

    public void setStorageService(@Nonnull StorageService storage) {
        this.checkSetterPreconditions();
        this.storageService = (StorageService)Constraint.isNotNull((Object)storage, (String)"StorageService cannot be null");
    }

    public void setCookieManager(@Nonnull CookieManager manager) {
        this.checkSetterPreconditions();
        this.cookieManager = (CookieManager)Constraint.isNotNull((Object)manager, (String)"CookieManager cannot be null");
    }

    public void setCookiePrefix(@Nonnull @NotEmpty String prefix) {
        this.checkSetterPreconditions();
        this.cookiePrefix = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)prefix), (String)"Cookie prefix cannot be null or empty");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.velocityEngine == null) {
            throw new ComponentInitializationException("VelocityEngine cannot be null");
        }
        if (this.velocityTemplateId == null) {
            throw new ComponentInitializationException("Velocity template ID cannot be null");
        }
        if (this.cookieManager == null) {
            throw new ComponentInitializationException("CookieManager cannot be null");
        }
        if (this.storageService == null) {
            throw new ComponentInitializationException("StorageService cannot be null");
        }
        if (!this.storageService.getCapabilities().isServerSide()) {
            throw new ComponentInitializationException("StorageService cannot be client-side");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.ensureOutputObjects();
        this.postData = this.getRecoveredData();
        if (this.postData == null) {
            return false;
        }
        if (!this.ensureAgent().isSupportsPostPreservation()) {
            this.log.warn("{} POST data preservation not permitted for agent", (Object)this.getLogPrefix());
            return false;
        }
        if (this.ensureAgentRequestContext().getTargetURL() == null) {
            this.log.warn("{} No definitive target resource, POST data recovery aborted", (Object)this.getLogPrefix());
            return false;
        }
        this.decoder = this.ensureAgent().getCharacterEncoding().newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        List params;
        AgentRequestContext agentRequestContext = this.ensureAgentRequestContext();
        String decodedTarget = RemotedHttpServletRequest.decodeUnsafeString((byte[])this.ensureAgentRequestContext().getTargetURL(), (CharsetDecoder)this.decoder, null);
        if (decodedTarget == null) {
            this.log.warn("{} Failure decoding target resource byte array using encoding: {}", (Object)this.getLogPrefix(), (Object)this.decoder.charset().name());
            return;
        }
        try {
            params = URISupport.parseQueryString((String)this.postData, (boolean)true, (boolean)true, (Charset)this.decoder.charset());
        }
        catch (IllegalArgumentException e) {
            this.log.warn("{} Failure decoding form parameters using encoding: {}", (Object)this.getLogPrefix(), (Object)this.decoder.charset().name());
            return;
        }
        for (Pair param : params) {
            param.setFirst((Object)HTMLEncoder.encodeForHTMLAttribute((String)((String)param.getFirst())));
            param.setSecond((Object)HTMLEncoder.encodeForHTMLAttribute((String)((String)param.getSecond())));
        }
        try {
            RemotedHttpServletRequestResponseContext.loadCurrent((RemotedHttpServletRequest)agentRequestContext.getRemotedHttpServletRequest(), (RemotedHttpServletResponse)agentRequestContext.getRemotedHttpServletResponse());
            this.log.debug("{} Recovering {} characters of POST data into form template", (Object)this.getLogPrefix(), (Object)this.postData.length());
            VelocityContext context = new VelocityContext();
            if (this.cspDigester != null) {
                this.log.trace("Adding CSP digester to context");
                context.put("cspDigester", (Object)this.cspDigester);
            }
            if (this.cspNonceGenerator != null) {
                this.log.trace("Adding CSP nonce generator to context");
                context.put("cspNonce", (Object)this.cspNonceGenerator);
            }
            context.put("action", (Object)HTMLEncoder.encodeForHTMLAttribute((String)decodedTarget));
            context.put("params", (Object)params);
            RemotedHttpServletResponse response = agentRequestContext.getRemotedHttpServletResponse();
            assert (response != null);
            context.put("response", (Object)response);
            HttpServletSupport.addNoCacheHeaders((HttpServletResponse)response);
            HttpServletSupport.setUTF8Encoding((HttpServletResponse)response);
            HttpServletSupport.setContentType((HttpServletResponse)response, (String)"text/html");
            response.setStatus(200);
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)response.getOutputStream(), this.decoder.charset());){
                this.velocityEngine.mergeTemplate(this.velocityTemplateId, this.decoder.charset().name(), (Context)context, (Writer)out);
                ((Writer)out).flush();
            }
            catch (IOException e) {
                this.log.error("{} Exception producing form response to client for POST recovery", (Object)this.getLogPrefix(), (Object)e);
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
            }
        }
        finally {
            RemotedHttpServletRequestResponseContext.clearCurrent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String getRecoveredData() {
        String stateToken;
        AgentRequestContext agentRequestContext = this.ensureAgentRequestContext();
        DDF input = agentRequestContext.getInput();
        String string = stateToken = input != null ? input.getmember("state").string() : null;
        if (stateToken == null) {
            this.log.debug("{} No state token found in request, skipping POST recovery check", (Object)this.getLogPrefix());
            return null;
        }
        if (stateToken.length() > 16) {
            stateToken = stateToken.substring(0, 16);
        }
        try {
            RemotedHttpServletRequestResponseContext.loadCurrent((RemotedHttpServletRequest)agentRequestContext.getRemotedHttpServletRequest(), (RemotedHttpServletResponse)agentRequestContext.getRemotedHttpServletResponse());
            String key = this.cookieManager.getCookieValue(this.cookiePrefix + stateToken, null);
            if (key == null) {
                this.log.debug("{} No recovery cookie for state token {}, skipping POST recovery check", (Object)this.getLogPrefix(), (Object)stateToken);
                String string2 = null;
                return string2;
            }
            this.cookieManager.unsetCookie(this.cookiePrefix + stateToken);
            StorageRecord record = this.storageService.read(this.ensureAgent().getId() + ".PostData", key);
            if (record == null) {
                this.log.warn("{} POST recovery record was missing for key: {}", (Object)this.getLogPrefix(), (Object)key);
                String string3 = null;
                return string3;
            }
            try {
                this.storageService.delete(this.ensureAgent().getId() + ".PostData", key);
            }
            catch (IOException e) {
                this.log.warn("{} Error deleting POST recovery record for key: {}", (Object)this.getLogPrefix(), (Object)key);
            }
            String string4 = record.getValue();
            return string4;
        }
        catch (IOException e) {
            this.log.error("{} Error reading storage record for POST data", (Object)this.getLogPrefix(), (Object)e);
        }
        finally {
            RemotedHttpServletRequestResponseContext.clearCurrent();
        }
        return null;
    }
}

