/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.profile.impl;

import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.net.CookieManager;
import net.shibboleth.shared.net.URISupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.sp.context.AgentRequestContext;
import net.shibboleth.sp.context.TokenConsumerContext;
import net.shibboleth.sp.messaging.RemotedHttpServletRequest;
import net.shibboleth.sp.messaging.RemotedHttpServletRequestResponseContext;
import net.shibboleth.sp.messaging.RemotedHttpServletResponse;
import net.shibboleth.sp.profile.AbstractApplicationAction;
import net.shibboleth.sp.profile.impl.IssueCorrelationCookie;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ProcessCorrelationCookie
extends AbstractApplicationAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ProcessCorrelationCookie.class);
    @NonnullAfterInit
    private CookieManager cookieManager;
    @Nonnull
    private String cookiePrefix = IssueCorrelationCookie.DEFAULT_COOKIE_PREFIX;
    @NonnullAfterInit
    private Function<ProfileRequestContext, String> stateTokenLookupStrategy;
    @NonnullBeforeExec
    private String stateToken;

    public void setCookieManager(@Nonnull CookieManager manager) {
        this.checkSetterPreconditions();
        this.cookieManager = (CookieManager)Constraint.isNotNull((Object)manager, (String)"CookieManager cannot be null");
    }

    public void setCookiePrefix(@Nonnull @NotEmpty String prefix) {
        this.checkSetterPreconditions();
        this.cookiePrefix = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)prefix), (String)"Cookie prefix cannot be null or empty");
    }

    public void setStateTokenLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.stateTokenLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Request ID lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.cookieManager == null) {
            throw new ComponentInitializationException("CookieManager cannot be null");
        }
        if (this.stateTokenLookupStrategy == null) {
            throw new ComponentInitializationException("State token lookup strategy cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.stateToken = this.stateTokenLookupStrategy.apply(profileRequestContext);
        if (this.stateToken == null) {
            this.log.debug("{} No state token found in request, skipping correlation cookie processing", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        this.ensureOutputObjects();
        AgentRequestContext agentRequestContext = this.ensureAgentRequestContext();
        try {
            RemotedHttpServletRequestResponseContext.loadCurrent((RemotedHttpServletRequest)agentRequestContext.getRemotedHttpServletRequest(), (RemotedHttpServletResponse)agentRequestContext.getRemotedHttpServletResponse());
            Escaper escaper = UrlEscapers.urlFormParameterEscaper();
            String cookieName = this.cookiePrefix + escaper.escape(this.stateToken);
            String value = this.cookieManager.getCookieValue(cookieName, null);
            if (value == null) {
                this.log.debug("{} No correlation cookie found for state token '{}'", (Object)this.getLogPrefix(), (Object)this.stateToken);
                return;
            }
            this.cookieManager.unsetCookie(cookieName);
            String decoded = URISupport.doURLDecode((String)value);
            this.log.debug("{} Extracted request ID '{}' for state token '{}'", new Object[]{this.getLogPrefix(), decoded, this.stateToken});
            ((TokenConsumerContext)agentRequestContext.ensureSubcontext(TokenConsumerContext.class)).setMessageCorrelationID(decoded);
        }
        finally {
            RemotedHttpServletRequestResponseContext.clearCurrent();
        }
    }
}

