/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.profile.impl;

import jakarta.servlet.http.HttpServletRequest;
import java.time.Instant;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.security.DataExpiredException;
import net.shibboleth.shared.security.DataSealer;
import net.shibboleth.shared.security.DataSealerException;
import net.shibboleth.sp.ddf.DDF;
import net.shibboleth.sp.profile.AbstractAgentAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class DoSealerOperation
extends AbstractAgentAction {
    @Nonnull
    @NotEmpty
    public static final String VALUE = "value";
    @Nonnull
    @NotEmpty
    public static final String EXP = "exp";
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DoSealerOperation.class);
    @NonnullAfterInit
    private DataSealer dataSealer;
    @NonnullBeforeExec
    private DDF input;

    public void setDataSealer(@Nonnull DataSealer sealer) {
        this.checkSetterPreconditions();
        this.dataSealer = (DataSealer)Constraint.isNotNull((Object)sealer, (String)"DataSealer cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.dataSealer == null) {
            throw new ComponentInitializationException("DataSealer cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (this.getHttpServletRequest() == null) {
            this.log.warn("{} No HttpServletRequest available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.input = this.ensureAgentRequestContext().getInput();
        if (this.input == null || !this.input.isstruct()) {
            this.log.warn("{} Invalid or missing input message", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        try {
            HttpServletRequest request = this.ensureHttpServletRequest();
            if ("GET".equals(request.getMethod())) {
                this.doUnwrap(profileRequestContext);
            } else if ("POST".equals(request.getMethod())) {
                this.doWrap(profileRequestContext);
            } else {
                this.log.warn("{} Invalid method: {}", (Object)this.getLogPrefix(), (Object)request.getMethod());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            }
        }
        catch (DataSealerException e) {
            this.log.error("{} Exception raised by DataSealer", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"MessageProcessingError");
        }
    }

    private void doUnwrap(@Nonnull ProfileRequestContext profileRequestContext) throws DataSealerException {
        String unwrapped;
        String wrapped = this.input.getmember(VALUE).string();
        if (wrapped == null) {
            this.log.warn("{} No value parameter supplied for unwrap operation", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
        try {
            unwrapped = this.dataSealer.unwrap(wrapped);
        }
        catch (DataExpiredException e) {
            this.log.info("{} Decrypted data was expired", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"MessageExpired");
            return;
        }
        String prefix = this.ensureAgent().getId() + "!";
        if (unwrapped.startsWith(prefix)) {
            DDF output = new DDF().structure();
            output.addmember(VALUE).string(unwrapped.substring(prefix.length()));
            this.ensureAgentRequestContext().setOutput(output);
        } else {
            this.log.warn("{} Encrypted data was not created by this agent", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"AccessDenied");
        }
    }

    private void doWrap(@Nonnull ProfileRequestContext profileRequestContext) throws DataSealerException {
        String unwrapped = this.input.getmember(VALUE).string();
        if (unwrapped == null) {
            this.log.warn("{} No value parameter supplied for wrap operation", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
        Long exp = this.input.getmember(EXP).longinteger();
        String wrapped = this.dataSealer.wrap(this.ensureAgent().getId() + "!" + unwrapped, exp != null ? Instant.ofEpochSecond(exp) : null);
        DDF output = new DDF().structure();
        output.addmember(VALUE).string(wrapped);
        this.ensureAgentRequestContext().setOutput(output);
    }
}

