/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.profile.impl;

import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.sp.context.AgentRequestContext;
import net.shibboleth.sp.ddf.DDF;
import net.shibboleth.sp.messaging.RemotedHttpServletRequest;
import net.shibboleth.sp.profile.AbstractAgentRequestAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class DecodeAgentRequest
extends AbstractAgentRequestAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DecodeAgentRequest.class);

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        HttpServletRequest request = this.getHttpServletRequest();
        if (request == null) {
            this.log.error("{} No HttpServletRequest available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        int contentLength = request.getContentLength();
        if (contentLength != 0) {
            String contentType = request.getContentType();
            if (!"text/plain".equals(contentType)) {
                this.log.warn("{} Invalid HTTP content type ({}), only text/plain supported", (Object)this.getLogPrefix(), (Object)contentType);
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
                return;
            }
            AgentRequestContext agentContext = this.ensureAgentRequestContext();
            try (ServletInputStream in = request.getInputStream();){
                DDF httpreq;
                assert (in != null);
                DDF msg = DDF.deserialize((InputStream)in);
                agentContext.setInput(msg);
                if (msg.isstruct() && (httpreq = msg.getmember("http")).isstruct()) {
                    this.log.debug("{} Wrapping tunnelled HTTP request", (Object)this.getLogPrefix());
                    agentContext.setRemotedHttpServletRequest(new RemotedHttpServletRequest(httpreq));
                }
            }
            catch (IOException e) {
                this.log.warn("{} Unable to parse input message from HttpServletRequest", (Object)this.getLogPrefix(), (Object)e);
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            }
        } else {
            this.log.warn("{} Content-Length was zero", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
        }
    }
}

