/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import net.shibboleth.shared.spring.config.IdentifiedComponentManager;
import net.shibboleth.sp.Agent;
import net.shibboleth.sp.AgentCriterion;
import net.shibboleth.sp.AgentResolver;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultAgentResolver
extends IdentifiedComponentManager<Agent>
implements AgentResolver {
    @NonnullAfterInit
    private Map<String, Agent> agentMap;

    @Autowired
    public DefaultAgentResolver(@Nullable Collection<Agent> agents) {
        super(agents);
    }

    public void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        this.agentMap = new HashMap<String, Agent>();
        for (Agent agent : this.getComponents()) {
            this.agentMap.put(agent.getId(), agent);
            for (Map.Entry creds : agent.getCredentials().entrySet()) {
                this.agentMap.put(creds.getKey() != null ? (String)creds.getKey() : agent.getId(), agent);
            }
        }
    }

    @Nullable
    public Agent resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        AgentCriterion c_agent;
        if (criteria != null && (c_agent = (AgentCriterion)criteria.get(AgentCriterion.class)) != null) {
            return this.agentMap.get(c_agent.getId());
        }
        return null;
    }

    @Nonnull
    public Iterable<Agent> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        Agent agent = this.resolveSingle(criteria);
        return agent != null ? CollectionSupport.singletonList((Object)agent) : CollectionSupport.emptyList();
    }
}

