/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.impl;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.codec.DecodingException;
import net.shibboleth.shared.codec.EncodingException;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.net.CookieManager;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import net.shibboleth.shared.security.RandomIdentifierParameterSpec;
import net.shibboleth.sp.Agent;
import net.shibboleth.sp.Application;
import net.shibboleth.sp.profile.AbstractStateTokenManager;
import org.slf4j.Logger;

public class CookieStateTokenManager
extends AbstractStateTokenManager {
    @Nonnull
    @NotEmpty
    public static String DEFAULT_PREFIX = "_shibsp_state_";
    @Nonnull
    private Logger log = LoggerFactory.getLogger(CookieStateTokenManager.class);
    @NonnullAfterInit
    private CookieManager cookieManager;
    @Nonnull
    @NotEmpty
    private String cookiePrefix = DEFAULT_PREFIX;

    public void setCookiePrefix(@Nonnull @NotEmpty String prefix) {
        this.checkSetterPreconditions();
        this.cookiePrefix = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)prefix), (String)"Cookie prefix cannot be null or empty");
    }

    public void setCookieManager(@Nonnull CookieManager manager) {
        this.checkSetterPreconditions();
        this.cookieManager = (CookieManager)Constraint.isNotNull((Object)manager, (String)"CookieManager cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.cookieManager == null) {
            throw new ComponentInitializationException("CookieManager cannot be null");
        }
        if (this.getIdentifierGenerationStrategy() == null) {
            RandomIdentifierParameterSpec spec = new RandomIdentifierParameterSpec(null, Integer.valueOf(6), null);
            try {
                this.setIdentifierGenerationStrategy(IdentifierGenerationStrategy.getInstance((IdentifierGenerationStrategy.ProviderType)IdentifierGenerationStrategy.ProviderType.SECURE, (IdentifierGenerationStrategy.ParameterSpec)spec));
            }
            catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
                throw new ComponentInitializationException((Exception)e);
            }
        }
    }

    @Nonnull
    public String preserveToStateToken(@Nonnull Agent agent, @Nonnull Application application, @Nonnull byte[] value) throws IOException {
        this.cookieManager.purgeStaleCookies(this.cookiePrefix);
        Instant ts = Instant.now();
        assert (ts != null);
        String key = Long.toString(ts.toEpochMilli()) + "_" + this.generateToken();
        String name = this.getCookieName(application, key);
        try {
            this.cookieManager.addCookie(name, Base64Support.encodeURLSafe((byte[])value), (int)this.getExpiration().toSeconds());
        }
        catch (EncodingException e) {
            throw new IOException(e);
        }
        this.log.trace("Created state token mapping from '{}' to value '{}'", (Object)name, (Object)value);
        return key;
    }

    @Nullable
    public byte[] recoverFromStateToken(@Nonnull Agent agent, @Nonnull Application application, @Nonnull String token) throws IOException {
        if (token.isEmpty()) {
            this.log.warn("Invalid state token: '{}'", (Object)token);
            return null;
        }
        String cookieName = this.getCookieName(application, token);
        String cookieValue = this.cookieManager.getCookieValue(cookieName, null);
        if (cookieValue != null) {
            this.log.trace("Recovered state token mapping from '{}' to value '{}'", (Object)token, (Object)cookieValue);
            this.cookieManager.unsetCookie(cookieName);
            try {
                return Base64Support.decodeURLSafe((String)cookieValue);
            }
            catch (DecodingException e) {
                throw new IOException(e);
            }
        }
        this.log.warn("No cookie found matching state token: '{}'", (Object)token);
        return null;
    }

    @Nonnull
    public String getCookieName(@Nonnull Application application, @Nonnull String uniquePortion) {
        StringBuilder builder = new StringBuilder(this.cookiePrefix);
        builder.append('_').append(application.getId()).append('_').append(uniquePortion);
        return builder.toString();
    }
}

