/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.authn.impl;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.impl.ValidateCredentials;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.servlet.HttpServletSupport;
import net.shibboleth.sp.Agent;
import net.shibboleth.sp.authn.impl.CachedAgentAuthentication;
import net.shibboleth.sp.context.AgentRequestContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ValidateAgentCredentials
extends ValidateCredentials {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ValidateAgentCredentials.class);
    @Nonnull
    private Function<ProfileRequestContext, AgentRequestContext> agentRequestContextLookupStrategy = new ChildContextLookup(AgentRequestContext.class);
    @Nonnull
    private Duration cacheDuration = Duration.ofHours(1L);

    public void setAgentRequestContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AgentRequestContext> strategy) {
        this.checkSetterPreconditions();
        this.agentRequestContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AgentRequestContext lookup strategy cannot be null");
    }

    public void setCacheDuration(@Nonnull Duration duration) {
        this.checkSetterPreconditions();
        this.cacheDuration = (Duration)Constraint.isNotNull((Object)duration, (String)"Cache duration cannot be null");
    }

    protected void buildAuthenticationResult(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        String id;
        Subject subject = this.populateSubject(this.getSubject());
        AgentRequestContext agentCtx = this.agentRequestContextLookupStrategy.apply(profileRequestContext);
        Agent agent = agentCtx != null ? agentCtx.getAgent() : null;
        String string = id = agent != null ? agent.getId() : null;
        if (id == null || !subject.getPrincipals(UsernamePrincipal.class).contains(new UsernamePrincipal(id))) {
            throw new IllegalStateException("Agent authentication result did not produce the expected results.");
        }
        assert (agent != null);
        if (agent.isSupportsCachedAuthentication()) {
            String address;
            HttpServletRequest request = this.getHttpServletRequest();
            HttpSession session = request != null ? request.getSession(true) : null;
            String string2 = address = request != null ? HttpServletSupport.getRemoteAddr((ServletRequest)request) : null;
            if (session != null && address != null) {
                session.setAttribute("net.shibboleth.sp.agent.cachedAuthentication", (Object)new CachedAgentAuthentication(id, address, Instant.now().plus(this.cacheDuration)));
            } else {
                this.log.warn("{} No session or client address available, skipping authentication caching", (Object)this.getLogPrefix());
            }
        }
    }
}

