/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.ddf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;

@NotThreadSafe
public class DDF
implements Iterable<DDF> {
    @Nullable
    private String name;
    @Nullable
    private DDF parent;
    @Nonnull
    private DDFType type;
    @Nullable
    private Object value;

    public DDF() {
        this.type = DDFType.DDF_NULL;
    }

    public DDF(@Nullable @NotEmpty String n) {
        this.type = DDFType.DDF_EMPTY;
        this.name(n);
    }

    public DDF(@Nullable @NotEmpty String n, @Nullable String val) {
        this(n);
        this.string(val);
    }

    public DDF(@Nullable @NotEmpty String n, @Nullable byte[] val) {
        this(n);
        this.unsafe_string(val);
    }

    public DDF(@Nullable @NotEmpty String n, int val) {
        this(n);
        this.integer(val);
    }

    public DDF(@Nullable @NotEmpty String n, long val) {
        this(n);
        this.longinteger(val);
    }

    public DDF(@Nullable @NotEmpty String n, double val) {
        this(n);
        this.floating(val);
    }

    @Nonnull
    public DDF destroy() {
        this.remove().empty().name(null);
        this.type = DDFType.DDF_NULL;
        return this;
    }

    @Nonnull
    DDF copy() {
        DDF dup = new DDF(this.name);
        switch (this.type) {
            case DDF_NULL: {
                dup.destroy();
                break;
            }
            case DDF_EMPTY: {
                break;
            }
            case DDF_STRING: {
                dup.string((String)this.value);
                break;
            }
            case DDF_STRING_UNSAFE: {
                dup.unsafe_string((byte[])this.value);
                break;
            }
            case DDF_INT: {
                assert (this.value instanceof Integer);
                dup.integer((Integer)this.value);
                break;
            }
            case DDF_LONG: {
                assert (this.value instanceof Long);
                dup.longinteger((Long)this.value);
                break;
            }
            case DDF_FLOAT: {
                assert (this.value instanceof Double);
                dup.floating((Double)this.value);
                break;
            }
            case DDF_STRUCT: {
                dup.structure();
                assert (this.value instanceof Map);
                for (DDF ddf : ((Map)this.value).values()) {
                    dup.add(ddf.copy());
                }
                break;
            }
            case DDF_LIST: {
                dup.list();
                assert (this.value instanceof List);
                for (DDF ddf : (List)this.value) {
                    dup.add(ddf.copy());
                }
                break;
            }
        }
        return dup;
    }

    @Nullable
    public String name() {
        return this.name;
    }

    @Nonnull
    public DDF name(@Nullable @NotEmpty String n) {
        DDF p = this.parent;
        if (!(this.isnull() || p != null && p.isstruct())) {
            this.name = n != null ? Constraint.isNotEmpty((String)n.substring(0, Integer.min(n.length(), 255)), (String)"Name cannot be empty") : null;
        }
        return this;
    }

    public boolean isnull() {
        return this.type == DDFType.DDF_NULL;
    }

    public boolean isempty() {
        return this.type == DDFType.DDF_EMPTY;
    }

    public boolean isstring() {
        return this.type == DDFType.DDF_STRING;
    }

    public boolean isunsafestring() {
        return this.type == DDFType.DDF_STRING_UNSAFE;
    }

    public boolean isint() {
        return this.type == DDFType.DDF_INT;
    }

    public boolean islong() {
        return this.type == DDFType.DDF_LONG;
    }

    public boolean isfloat() {
        return this.type == DDFType.DDF_FLOAT;
    }

    public boolean isstruct() {
        return this.type == DDFType.DDF_STRUCT;
    }

    public boolean islist() {
        return this.type == DDFType.DDF_LIST;
    }

    @Nullable
    public String string() {
        return this.isstring() ? (String)this.value : null;
    }

    @Nullable
    public byte[] unsafe_string() {
        return this.isunsafestring() ? (byte[])this.value : null;
    }

    @Nullable
    public Integer integer() {
        switch (this.type) {
            case DDF_INT: {
                return (Integer)this.value;
            }
            case DDF_LONG: {
                assert (this.value instanceof Long);
                return ((Long)this.value).intValue();
            }
            case DDF_FLOAT: {
                assert (this.value instanceof Double);
                return ((Double)this.value).intValue();
            }
            case DDF_STRING: {
                try {
                    return Integer.valueOf((String)this.value);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            case DDF_STRUCT: {
                assert (this.value instanceof Map);
                return ((Map)this.value).size();
            }
            case DDF_LIST: {
                assert (this.value instanceof List);
                return ((List)this.value).size();
            }
        }
        return null;
    }

    @Nullable
    public Long longinteger() {
        switch (this.type) {
            case DDF_INT: {
                assert (this.value instanceof Integer);
                return ((Integer)this.value).longValue();
            }
            case DDF_LONG: {
                return (Long)this.value;
            }
            case DDF_FLOAT: {
                assert (this.value instanceof Double);
                return ((Double)this.value).longValue();
            }
            case DDF_STRING: {
                try {
                    return Long.valueOf((String)this.value);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            case DDF_STRUCT: {
                assert (this.value instanceof Map);
                return ((Map)this.value).size();
            }
            case DDF_LIST: {
                assert (this.value instanceof List);
                return ((List)this.value).size();
            }
        }
        return null;
    }

    @Nullable
    public Double floating() {
        switch (this.type) {
            case DDF_INT: {
                assert (this.value instanceof Integer);
                return ((Integer)this.value).doubleValue();
            }
            case DDF_LONG: {
                assert (this.value instanceof Long);
                return ((Long)this.value).doubleValue();
            }
            case DDF_FLOAT: {
                return (Double)this.value;
            }
            case DDF_STRING: {
                try {
                    return Double.valueOf((String)this.value);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            case DDF_STRUCT: {
                assert (this.value instanceof Map);
                return ((Map)this.value).size();
            }
            case DDF_LIST: {
                assert (this.value instanceof List);
                return ((List)this.value).size();
            }
        }
        return null;
    }

    @Nonnull
    public DDF empty() {
        this.type = DDFType.DDF_EMPTY;
        this.value = null;
        return this;
    }

    @Nonnull
    public DDF string(@Nullable String val) {
        this.empty();
        this.value = val;
        this.type = DDFType.DDF_STRING;
        return this;
    }

    @Nonnull
    public DDF unsafe_string(@Nullable byte[] val) {
        this.empty();
        this.value = val;
        this.type = DDFType.DDF_STRING_UNSAFE;
        return this;
    }

    @Nonnull
    public DDF string(int val) {
        return this.string(Integer.toString(val));
    }

    @Nonnull
    public DDF string(long val) {
        return this.string(Long.toString(val));
    }

    @Nonnull
    public DDF string(double val) {
        return this.string(Double.toString(val));
    }

    @Nonnull
    public DDF integer(int val) {
        this.empty();
        this.value = val;
        this.type = DDFType.DDF_INT;
        return this;
    }

    @Nonnull
    public DDF integer(@Nonnull @NotEmpty String val) {
        this.empty();
        try {
            return this.integer(Integer.valueOf(val));
        }
        catch (NumberFormatException e) {
            return this.integer(0);
        }
    }

    @Nonnull
    public DDF longinteger(long val) {
        this.empty();
        this.value = val;
        this.type = DDFType.DDF_LONG;
        return this;
    }

    @Nonnull
    public DDF longinteger(@Nonnull @NotEmpty String val) {
        this.empty();
        try {
            return this.longinteger(Long.valueOf(val));
        }
        catch (NumberFormatException e) {
            return this.longinteger(0L);
        }
    }

    @Nonnull
    public DDF floating(double val) {
        this.empty();
        this.value = val;
        this.type = DDFType.DDF_FLOAT;
        return this;
    }

    @Nonnull
    public DDF floating(@Nonnull @NotEmpty String val) {
        this.empty();
        try {
            return this.floating(Double.valueOf(val));
        }
        catch (NumberFormatException e) {
            return this.floating(0.0);
        }
    }

    @Nonnull
    public DDF structure() {
        this.empty();
        this.value = new LinkedHashMap();
        this.type = DDFType.DDF_STRUCT;
        return this;
    }

    @Nonnull
    public DDF list() {
        this.empty();
        this.value = new ArrayList();
        this.type = DDFType.DDF_LIST;
        return this;
    }

    @Nonnull
    public DDF add(@Nonnull DDF child) {
        if (!this.isstruct() && !this.islist() || child.isnull() || this == child.parent) {
            return child;
        }
        if (this.isstruct()) {
            if (child.name == null) {
                return child;
            }
            assert (child.name != null);
            this.getmember(child.name).destroy();
            child.remove();
            assert (this.value instanceof Map);
            ((Map)this.value).put(child.name, child);
        } else {
            child.remove();
            assert (this.value instanceof List);
            ((List)this.value).add(child);
        }
        child.parent = this;
        return child;
    }

    @Nonnull
    public DDF addbefore(@Nonnull DDF child, @Nonnull DDF before) {
        if (!this.islist() || child.isnull() || before.parent != this) {
            return child;
        }
        child.remove();
        List list = (List)this.value;
        assert (list != null);
        list.add(list.indexOf(before), child);
        child.parent = this;
        return child;
    }

    @Nonnull
    public DDF addafter(@Nonnull DDF child, @Nonnull DDF after) {
        if (!this.islist() || child.isnull() || after.parent != this) {
            return child;
        }
        child.remove();
        List list = (List)this.value;
        assert (list != null);
        int i = list.indexOf(after);
        if (i == list.size() - 1) {
            list.add(child);
        } else {
            list.add(i + 1, child);
        }
        child.parent = this;
        return child;
    }

    @Nonnull
    public DDF remove() {
        DDF p = this.parent;
        if (p != null) {
            if (p.isstruct()) {
                assert (p.value instanceof Map);
                ((Map)p.value).remove(this.name);
            } else {
                assert (p.value instanceof List);
                ((List)p.value).remove(this);
            }
            this.parent = null;
        }
        return this;
    }

    @Nullable
    public DDF parent() {
        return this.parent;
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public Map<String, DDF> asMap() {
        if (this.isstruct()) {
            assert (this.value instanceof Map);
            return CollectionSupport.copyToMap((Map)((Map)this.value));
        }
        return CollectionSupport.emptyMap();
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public List<DDF> asList() {
        if (this.isstruct()) {
            assert (this.value instanceof Map);
            return CollectionSupport.copyToList(((Map)this.value).values());
        }
        if (this.islist()) {
            assert (this.value instanceof List);
            return CollectionSupport.copyToList((Collection)((List)this.value));
        }
        return CollectionSupport.emptyList();
    }

    @Nonnull
    public DDF addmember(@Nonnull @NotEmpty String path) {
        Object[] tokens = Constraint.isNotEmpty((String)path, (String)"Path cannot be null").split("\\.");
        Constraint.isNotEmpty((Object[])tokens, (String)"Path did not produce an array of path segments");
        if (!this.isnull()) {
            DDF base = this;
            for (Object segment : tokens) {
                if (!base.isstruct()) {
                    base.structure();
                }
                assert (segment != null);
                DDF node = base.getmember((String)segment);
                if (node.isnull()) {
                    node = base.add(new DDF((String)segment));
                }
                base = node;
            }
            return base;
        }
        return new DDF();
    }

    @Nonnull
    public DDF getmember(@Nonnull @NotEmpty String path) {
        String[] tokens = path.split("\\.");
        if (tokens == null || tokens.length == 0 || this.isnull()) {
            return new DDF();
        }
        DDF current = this;
        int i = 0;
        while (i < tokens.length) {
            if (tokens[i].startsWith("[") && tokens[i].endsWith("]")) {
                List currentValue;
                int index;
                try {
                    index = Integer.valueOf(tokens[i].substring(1, tokens[i].length() - 1));
                }
                catch (NumberFormatException e) {
                    index = 0;
                }
                if (current.islist()) {
                    assert (current.value instanceof List);
                    currentValue = (List)current.value;
                    if (index >= currentValue.size()) {
                        return new DDF();
                    }
                } else {
                    return new DDF();
                }
                current = (DDF)currentValue.get(index);
                ++i;
                continue;
            }
            if (current.isstruct()) {
                assert (current.value instanceof Map);
                current = (DDF)((Map)current.value).get(tokens[i]);
                if (current == null) {
                    return new DDF();
                }
                ++i;
                continue;
            }
            if (current.islist()) {
                assert (current.value instanceof List);
                current = (DDF)((List)current.value).get(0);
                if (current != null) continue;
                return new DDF();
            }
            return new DDF();
        }
        assert (current != null);
        return current;
    }

    @Override
    @Nonnull
    public Iterator<DDF> iterator() {
        List<DDF> list = this.asList();
        if (list != null) {
            return list.iterator();
        }
        return Collections.emptyListIterator();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DDF other = (DDF)obj;
        if (this.name == null ? other.name != null : this.name != null && !this.name.equals(other.name)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return !(this.value == null ? other.value != null : this.value != null && !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = this.name != null ? this.name.hashCode() + 31 * result : 31 * result;
        result = this.parent != null ? this.parent.hashCode() + 31 * result : 31 * result;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = this.value != null ? this.value.hashCode() + 31 * result : 31 * result;
        return result;
    }

    @Nonnull
    public String toString() {
        return this.dump(new StringBuilder(), 0L).toString();
    }

    @Nonnull
    private StringBuilder dump(@Nonnull StringBuilder builder, long indent) {
        long i;
        for (i = 0L; i < indent; ++i) {
            builder.append(' ');
        }
        switch (this.type) {
            case DDF_NULL: {
                builder.append("null");
                break;
            }
            case DDF_EMPTY: {
                builder.append("empty");
                if (this.name == null) break;
                builder.append(' ').append(this.name);
                break;
            }
            case DDF_STRING: {
                builder.append("String");
                if (this.name != null) {
                    builder.append(' ').append(this.name);
                }
                builder.append(" = ");
                if (this.value != null) {
                    String valueCopy = (String)this.value;
                    builder.append('\"').append(valueCopy.replace("\"", "\\\"")).append('\"');
                    break;
                }
                builder.append("null");
                break;
            }
            case DDF_STRING_UNSAFE: {
                builder.append("byte[]");
                if (this.name != null) {
                    builder.append(' ').append(this.name);
                }
                builder.append(" = ");
                if (this.value != null) {
                    byte[] valueCopy = (byte[])this.value;
                    builder.append('{');
                    for (byte b : valueCopy) {
                        builder.append(Integer.toHexString(b)).append(", ");
                    }
                    builder.append('}');
                    break;
                }
                builder.append("null");
                break;
            }
            case DDF_INT: {
                builder.append("Integer");
                if (this.name != null) {
                    builder.append(' ').append(this.name);
                }
                builder.append(" = ").append(this.value);
                break;
            }
            case DDF_LONG: {
                builder.append("Long");
                if (this.name != null) {
                    builder.append(' ').append(this.name);
                }
                builder.append(" = ").append(this.value);
                break;
            }
            case DDF_FLOAT: {
                builder.append("Double");
                if (this.name != null) {
                    builder.append(' ').append(this.name);
                }
                builder.append(" = ").append(this.value);
                break;
            }
            case DDF_STRUCT: {
                builder.append("struct");
                if (this.name != null) {
                    builder.append(' ').append(this.name);
                }
                builder.append(" = {");
                assert (this.value instanceof Map);
                if (!((Map)this.value).isEmpty()) {
                    builder.append('\n');
                    for (DDF child : this) {
                        child.dump(builder, indent + 2L);
                    }
                }
                for (i = 0L; i < indent; ++i) {
                    builder.append(' ');
                }
                builder.append('}');
                break;
            }
            case DDF_LIST: {
                assert (this.value instanceof List);
                List valueCopy = (List)this.value;
                builder.append("DDF[").append(valueCopy.size()).append(']');
                if (this.name != null) {
                    builder.append(' ').append(this.name);
                }
                builder.append(" = {");
                if (!valueCopy.isEmpty()) {
                    builder.append('\n');
                    for (DDF child : this) {
                        child.dump(builder, indent + 2L);
                    }
                }
                for (long i2 = 0L; i2 < indent; ++i2) {
                    builder.append(' ');
                }
                builder.append('}');
                break;
            }
            default: {
                builder.append("UNKNOWN -- WARNING: ILLEGAL VALUE");
            }
        }
        builder.append(";\n");
        return builder;
    }

    @Nonnull
    public OutputStream serialize(@Nonnull OutputStream os) throws IOException {
        if (!this.isnull()) {
            if (this.name != null) {
                DDF.encode(os, this.name.getBytes(StandardCharsets.UTF_8));
            } else {
                os.write(46);
            }
            os.write(32);
            switch (this.type) {
                case DDF_EMPTY: {
                    os.write(Integer.toString(DDFType.DDF_EMPTY.getValue()).getBytes(StandardCharsets.UTF_8));
                    os.write(10);
                    break;
                }
                case DDF_STRING: {
                    os.write(Integer.toString(this.type.getValue()).getBytes(StandardCharsets.UTF_8));
                    if (this.value != null) {
                        os.write(32);
                        assert (this.value instanceof String);
                        DDF.encode(os, ((String)this.value).getBytes(StandardCharsets.UTF_8));
                    }
                    os.write(10);
                    break;
                }
                case DDF_STRING_UNSAFE: {
                    os.write(Integer.toString(this.type.getValue()).getBytes(StandardCharsets.UTF_8));
                    if (this.value != null) {
                        os.write(32);
                        assert (this.value instanceof byte[]);
                        DDF.encode(os, (byte[])this.value);
                    }
                    os.write(10);
                    break;
                }
                case DDF_INT: {
                    os.write(Integer.toString(this.type.getValue()).getBytes(StandardCharsets.UTF_8));
                    os.write(32);
                    assert (this.value instanceof Integer);
                    os.write(Integer.toString((Integer)this.value).getBytes(StandardCharsets.UTF_8));
                    os.write(10);
                    break;
                }
                case DDF_LONG: {
                    os.write(Integer.toString(this.type.getValue()).getBytes(StandardCharsets.UTF_8));
                    os.write(32);
                    assert (this.value instanceof Long);
                    os.write(Long.toString((Long)this.value).getBytes(StandardCharsets.UTF_8));
                    os.write(10);
                    break;
                }
                case DDF_FLOAT: {
                    os.write(Integer.toString(this.type.getValue()).getBytes(StandardCharsets.UTF_8));
                    os.write(32);
                    assert (this.value instanceof Double);
                    os.write(Double.toString((Double)this.value).getBytes(StandardCharsets.UTF_8));
                    os.write(10);
                    break;
                }
                case DDF_STRUCT: {
                    assert (this.value instanceof Map);
                    Collection members = ((Map)this.value).values();
                    os.write(Integer.toString(this.type.getValue()).getBytes(StandardCharsets.UTF_8));
                    os.write(32);
                    os.write(Integer.toString(members.size()).getBytes(StandardCharsets.UTF_8));
                    os.write(10);
                    for (DDF child : members) {
                        child.serialize(os);
                    }
                    break;
                }
                case DDF_LIST: {
                    assert (this.value instanceof List);
                    List children = (List)this.value;
                    os.write(Integer.toString(this.type.getValue()).getBytes(StandardCharsets.UTF_8));
                    os.write(32);
                    os.write(Integer.toString(children.size()).getBytes(StandardCharsets.UTF_8));
                    os.write(10);
                    for (DDF child : children) {
                        child.serialize(os);
                    }
                    break;
                }
            }
        }
        return os;
    }

    @Nonnull
    public static DDF deserialize(@Nonnull InputStream is) throws IOException {
        DDFType type;
        int ch;
        StringBuilder nameBuilder = new StringBuilder();
        while ((ch = is.read()) != -1 && !Character.isWhitespace(ch)) {
            if (ch >= 0 && ch <= 127) {
                nameBuilder.appendCodePoint(ch);
                continue;
            }
            throw new IOException("Invalid code point outside US-ASCII range");
        }
        if (ch != 32) {
            throw new IOException("Name not followed by space character");
        }
        String name = nameBuilder.toString();
        if (name.isEmpty()) {
            throw new IOException("Name field missing");
        }
        DDF obj = new DDF(null);
        if (!".".equals(name)) {
            try {
                obj.name(URLDecoder.decode(name, StandardCharsets.UTF_8));
            }
            catch (IllegalArgumentException e) {
                throw new IOException(e);
            }
        }
        StringBuilder typeBuilder = new StringBuilder();
        while ((ch = is.read()) != -1 && Character.isDigit(ch)) {
            typeBuilder.appendCodePoint(ch);
        }
        try {
            type = DDFType.valueOf(Integer.valueOf(typeBuilder.toString()));
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Invalid DDF type");
        }
        StringBuilder valueBuilder = new StringBuilder();
        switch (type) {
            case DDF_EMPTY: {
                if (ch != 10) {
                    throw new IOException("Empty record not terminated by linefeed");
                }
                return obj;
            }
            case DDF_STRING: 
            case DDF_STRING_UNSAFE: {
                if (ch == 10) {
                    if (type == DDFType.DDF_STRING) {
                        return obj.string(null);
                    }
                    return obj.unsafe_string(null);
                }
                if (ch != 32) {
                    throw new IOException("Type field not followed by space character");
                }
                while ((ch = is.read()) != -1 && !Character.isWhitespace(ch)) {
                    if (ch >= 0 && ch <= 127) {
                        valueBuilder.appendCodePoint(ch);
                        continue;
                    }
                    throw new IOException("Invalid code point outside US-ASCII range");
                }
                if (ch != 10) {
                    throw new IOException("String value not followed by linefeed");
                }
                try {
                    if (type == DDFType.DDF_STRING) {
                        return obj.string(URLDecoder.decode(valueBuilder.toString(), StandardCharsets.UTF_8));
                    }
                    return obj.unsafe_string(URLDecoder.decode(valueBuilder.toString(), StandardCharsets.ISO_8859_1).getBytes(StandardCharsets.ISO_8859_1));
                }
                catch (IllegalArgumentException e) {
                    throw new IOException(e);
                }
            }
            case DDF_INT: 
            case DDF_LONG: 
            case DDF_FLOAT: {
                if (ch != 32) {
                    throw new IOException("Type field not followed by space character");
                }
                while ((ch = is.read()) != -1 && !Character.isWhitespace(ch)) {
                    if (ch >= 0 && ch <= 127) {
                        valueBuilder.appendCodePoint(ch);
                        continue;
                    }
                    throw new IOException("Invalid code point outside US-ASCII range");
                }
                if (ch != 10) {
                    throw new IOException("Numeric value not followed by linefeed");
                }
                if (valueBuilder.length() == 0) {
                    throw new IOException("Numeric value missing");
                }
                if (type == DDFType.DDF_INT) {
                    return obj.integer(valueBuilder.toString());
                }
                if (type == DDFType.DDF_LONG) {
                    return obj.longinteger(valueBuilder.toString());
                }
                return obj.floating(valueBuilder.toString());
            }
            case DDF_STRUCT: 
            case DDF_LIST: {
                int count;
                if (ch != 32) {
                    throw new IOException("Type field not followed by space character");
                }
                while ((ch = is.read()) != -1 && Character.isDigit(ch)) {
                    valueBuilder.appendCodePoint(ch);
                }
                if (ch != 10) {
                    throw new IOException("Record count not followed by linefeed");
                }
                if (valueBuilder.length() == 0) {
                    throw new IOException("Record count missing");
                }
                try {
                    count = Integer.valueOf(valueBuilder.toString());
                }
                catch (NumberFormatException e) {
                    throw new IOException("Invalid record count");
                }
                if (type == DDFType.DDF_STRUCT) {
                    obj.structure();
                } else {
                    obj.list();
                }
                while (count > 0) {
                    obj.add(DDF.deserialize(is));
                    --count;
                }
                return obj;
            }
        }
        throw new IOException("Unexpected record type");
    }

    static void encode(@Nonnull OutputStream os, @Nonnull byte[] bytes) throws IOException {
        for (byte b : bytes) {
            int i = Byte.toUnsignedInt(b);
            if (i < 48 || i > 122) {
                os.write(37);
                os.write(DDF.hexchar(i >>> 4));
                os.write(DDF.hexchar(i & 0xF));
                continue;
            }
            os.write(b);
        }
    }

    private static int hexchar(int b) {
        return b <= 9 ? 48 + b : 65 + b - 10;
    }

    public static enum DDFType {
        DDF_NULL(-1),
        DDF_EMPTY(0),
        DDF_STRING(1),
        DDF_INT(2),
        DDF_FLOAT(3),
        DDF_STRUCT(4),
        DDF_LIST(5),
        DDF_STRING_UNSAFE(6),
        DDF_LONG(7);

        private final int value;

        private DDFType(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public static DDFType valueOf(int val) throws IllegalArgumentException {
            return switch (val) {
                case -1 -> DDF_NULL;
                case 0 -> DDF_EMPTY;
                case 1 -> DDF_STRING;
                case 2 -> DDF_INT;
                case 3 -> DDF_FLOAT;
                case 4 -> DDF_STRUCT;
                case 5 -> DDF_LIST;
                case 6 -> DDF_STRING_UNSAFE;
                case 7 -> DDF_LONG;
                default -> throw new IllegalArgumentException("Unrecognized DDF type");
            };
        }
    }
}

