/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.profile.context.navigate.messaging;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.metadata.impl.ReloadableMetadataResolver;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.sp.Application;
import net.shibboleth.sp.context.AgentRequestContext;
import net.shibboleth.sp.profile.context.navigate.messaging.AbstractAgentRequestLookupFunction;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.RoleDescriptorResolver;
import org.opensaml.saml.metadata.resolver.impl.PredicateRoleDescriptorResolver;
import org.slf4j.Logger;

public class ApplicationMetadataResolverLookupFunction
extends AbstractAgentRequestLookupFunction<RoleDescriptorResolver> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ApplicationMetadataResolverLookupFunction.class);

    @Override
    @Nullable
    public RoleDescriptorResolver apply(@Nullable MessageContext input) {
        Application application;
        AgentRequestContext arc = this.getAgentRequestContext(input);
        if (arc != null && (application = arc.getApplication()) != null) {
            try {
                ReloadableMetadataResolver metadataResolver = new ReloadableMetadataResolver(application.getMetadataResolver());
                metadataResolver.setId(application.getId() + " MetadataResolver");
                metadataResolver.initialize();
                PredicateRoleDescriptorResolver roleResolver = new PredicateRoleDescriptorResolver((MetadataResolver)metadataResolver);
                roleResolver.initialize();
                return roleResolver;
            }
            catch (ComponentInitializationException e) {
                this.log.error("Exception wrapping Application-supplied MetadataResolver for use", (Throwable)e);
            }
        }
        return null;
    }
}

