/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.profile.context.logic;

import io.micrometer.common.lang.Nullable;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.servlet.HttpServletRequestValidator;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class HttpServletRequestPredicate
extends AbstractInitializableComponent
implements Predicate<ProfileRequestContext> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(HttpServletRequestPredicate.class);
    @NonnullAfterInit
    private NonnullSupplier<HttpServletRequest> httpServletRequestSupplier;
    @NonnullAfterInit
    private HttpServletRequestValidator requestValidator;

    public void setHttpServletRequestSupplier(@Nullable NonnullSupplier<HttpServletRequest> supplier) {
        this.httpServletRequestSupplier = supplier;
    }

    public void setHttpServletRequestValidator(@Nonnull HttpServletRequestValidator validator) {
        this.requestValidator = (HttpServletRequestValidator)Constraint.isNotNull((Object)validator, (String)"HttpServletRequestValidator cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.httpServletRequestSupplier == null) {
            throw new ComponentInitializationException("HttpServletRequest supplier was null");
        }
        if (this.requestValidator == null) {
            throw new ComponentInitializationException("HttpServletRequestValidator was null");
        }
    }

    @Override
    public boolean test(@Nullable ProfileRequestContext input) {
        try {
            this.requestValidator.validate((HttpServletRequest)this.httpServletRequestSupplier.get());
        }
        catch (ServletException e) {
            this.log.debug("Request failed validation: {}", (Object)e.getMessage());
            return false;
        }
        return true;
    }
}

