/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.profile;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.sp.Agent;
import net.shibboleth.sp.Application;
import net.shibboleth.sp.context.AgentRequestContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public abstract class AbstractAgentRequestAction
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractAgentRequestAction.class);
    @Nullable
    private String logPrefix;
    @Nonnull
    private Function<ProfileRequestContext, AgentRequestContext> agentRequestContextLookupStrategy = new ChildContextLookup(AgentRequestContext.class);
    @NonnullBeforeExec
    private AgentRequestContext agentRequestContext;

    @Nullable
    public AgentRequestContext getAgentRequestContext() {
        return this.agentRequestContext;
    }

    @Nonnull
    public AgentRequestContext ensureAgentRequestContext() {
        return (AgentRequestContext)((Object)Constraint.isNotNull((Object)((Object)this.agentRequestContext), (String)"AgentRequestContext was null"));
    }

    public void setAgentRequestContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AgentRequestContext> strategy) {
        this.checkSetterPreconditions();
        this.agentRequestContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AgentRequestContext lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.agentRequestContext = this.agentRequestContextLookupStrategy.apply(profileRequestContext);
        if (this.agentRequestContext == null) {
            this.log.error("{} No AgentRequestContext found", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        return true;
    }

    @Nonnull
    protected String getLogPrefix() {
        if (this.logPrefix != null) {
            return this.logPrefix;
        }
        StringBuilder s = new StringBuilder();
        AgentRequestContext ctx = this.getAgentRequestContext();
        if (ctx != null) {
            Application app;
            Agent agent = ctx.getAgent();
            if (agent != null) {
                s.append("Agent ").append(agent.getId()).append(" - ");
            }
            if ((app = ctx.getApplication()) != null) {
                s.append(" Application ").append(app.getApplicationId()).append(" - ");
            }
        }
        s.append(super.getLogPrefix());
        this.logPrefix = s.toString();
        assert (this.logPrefix != null);
        return this.logPrefix;
    }
}

