/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.profile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.sp.Agent;
import net.shibboleth.sp.context.AgentRequestContext;
import net.shibboleth.sp.ddf.DDF;
import net.shibboleth.sp.messaging.RemotedHttpServletResponse;
import net.shibboleth.sp.profile.AbstractAgentRequestAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public abstract class AbstractAgentAction
extends AbstractAgentRequestAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractAgentAction.class);
    @NonnullBeforeExec
    private Agent agent;
    private boolean createOutputObjects;

    public boolean isCreateOutputObjects() {
        return this.createOutputObjects;
    }

    public void setCreateOutputObjects(boolean flag) {
        this.checkSetterPreconditions();
        this.createOutputObjects = flag;
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.agent = this.ensureAgentRequestContext().getAgent();
        if (this.agent == null) {
            this.log.error("{} No Agent found in context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        return true;
    }

    @Nullable
    public Agent getAgent() {
        return this.agent;
    }

    @Nonnull
    public Agent ensureAgent() {
        return (Agent)Constraint.isNotNull((Object)this.agent, (String)"Agent was null");
    }

    protected void ensureOutputObjects() {
        AgentRequestContext agentRequestContext = this.ensureAgentRequestContext();
        if (this.isCreateOutputObjects() && agentRequestContext.getOutput() == null) {
            DDF output = new DDF(null);
            agentRequestContext.setOutput(output);
            agentRequestContext.setRemotedHttpServletResponse(new RemotedHttpServletResponse(output.structure().addmember("http")));
        }
    }
}

