/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.messaging;

import com.google.common.collect.ArrayListMultimap;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.ReadListener;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletConnection;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.servlet.http.Part;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.net.URISupport;
import net.shibboleth.sp.ddf.DDF;

@NotThreadSafe
public class RemotedHttpServletRequest
implements HttpServletRequest {
    @Nonnull
    @NotEmpty
    public static final String STRUCTURE_NAME = "http";
    @Nonnull
    @NotEmpty
    public static final String REQUEST_URL = "url";
    @Nonnull
    @NotEmpty
    public static final String REQUEST_URI = "uri";
    @Nonnull
    @NotEmpty
    public static final String METHOD = "method";
    @Nonnull
    @NotEmpty
    public static final String REMOTE_ADDR = "remote_addr";
    @Nonnull
    @NotEmpty
    public static final String LOCAL_ADDR = "local_addr";
    @Nonnull
    @NotEmpty
    public static final String QUERY_STRING = "query";
    @Nonnull
    @NotEmpty
    public static final String BODY = "body";
    @Nonnull
    @NotEmpty
    public static final String CONTENT_TYPE = "content_type";
    @Nonnull
    @NotEmpty
    public static final String CONTENT_LENGTH = "content_length";
    @Nonnull
    private static final byte[] EMPTY_BODY = new byte[0];
    @Nonnull
    private static final CharsetDecoder UTF_8 = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
    @Nonnull
    private final DDF obj;
    @Nonnull
    private final CharsetDecoder decoder;
    @NonnullElements
    private List<Cookie> cookies;
    @Nullable
    private Map<String, String[]> parameters;

    public RemotedHttpServletRequest(@Nonnull DDF ddf) {
        this(ddf, UTF_8);
    }

    public RemotedHttpServletRequest(@Nonnull DDF ddf, @Nonnull CharsetDecoder dec) {
        this.obj = (DDF)Constraint.isNotNull((Object)ddf, (String)"DDF cannot be null");
        this.decoder = (CharsetDecoder)Constraint.isNotNull((Object)dec, (String)"CharsetDecoder cannot be null");
    }

    @Nonnull
    public DDF getDDF() {
        return this.obj;
    }

    public Object getAttribute(String name) {
        return null;
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.emptyEnumeration();
    }

    public String getCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        throw new UnsupportedOperationException("setCharacterEncoding");
    }

    public int getContentLength() {
        Integer i = this.obj.getmember(CONTENT_LENGTH).integer();
        return i != null ? i : -1;
    }

    public long getContentLengthLong() {
        return this.getContentLength();
    }

    public String getContentType() {
        return this.obj.getmember(CONTENT_TYPE).string();
    }

    public ServletInputStream getInputStream() throws IOException {
        byte[] body = this.obj.getmember(BODY).unsafe_string();
        if (body != null) {
            return new BodyInputStream(body);
        }
        return new BodyInputStream(EMPTY_BODY);
    }

    public String getParameter(String name) {
        String[] values = this.getParameterMap().get(name);
        if (values != null) {
            return values[0];
        }
        return null;
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.getParameterMap().keySet());
    }

    public String[] getParameterValues(String name) {
        return this.getParameterMap().get(name);
    }

    public Map<String, String[]> getParameterMap() {
        if (this.parameters == null) {
            byte[] body;
            HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
            ArrayListMultimap multimap = ArrayListMultimap.create();
            String qs = this.getQueryString();
            if (qs != null) {
                List qparams = URISupport.parseQueryString((String)qs);
                for (Pair p : qparams) {
                    multimap.put((Object)((String)p.getFirst()), (Object)((String)p.getSecond()));
                }
            }
            if ("application/x-www-form-urlencoded".equals(this.getContentType()) && (body = this.obj.getmember(BODY).unsafe_string()) != null) {
                List qparams = URISupport.parseQueryString((String)RemotedHttpServletRequest.decodeUnsafeString(body, this.decoder, null));
                for (Pair p : qparams) {
                    multimap.put((Object)((String)p.getFirst()), (Object)((String)p.getSecond()));
                }
            }
            for (Map.Entry entry : multimap.asMap().entrySet()) {
                parameterMap.put((String)entry.getKey(), ((Collection)entry.getValue()).toArray(new String[((Collection)entry.getValue()).size()]));
            }
            this.parameters = parameterMap;
        }
        return this.parameters;
    }

    public String getRequestId() {
        return null;
    }

    public String getProtocolRequestId() {
        return "";
    }

    public ServletConnection getServletConnection() {
        throw new UnsupportedOperationException("getServletConnection");
    }

    public String getProtocol() {
        String protocol = this.obj.getmember("protocol").string();
        return protocol != null ? protocol : "HTTP/1.1";
    }

    public String getScheme() {
        return this.obj.getmember("scheme").string();
    }

    public String getServerName() {
        return RemotedHttpServletRequest.decodeUnsafeString(this.obj.getmember("hostname").unsafe_string(), this.decoder, null);
    }

    public int getServerPort() {
        Integer i = this.obj.getmember("port").integer();
        return i != null ? i : -1;
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(this.obj.getmember(BODY).unsafe_string()), this.decoder.charset()));
    }

    public String getRemoteAddr() {
        return this.obj.getmember(REMOTE_ADDR).string();
    }

    public String getRemoteHost() {
        return this.obj.getmember(REMOTE_ADDR).string();
    }

    public void setAttribute(String name, Object o) {
        throw new UnsupportedOperationException("setAttribute");
    }

    public void removeAttribute(String name) {
        throw new UnsupportedOperationException("removeAttribute");
    }

    public Locale getLocale() {
        throw new UnsupportedOperationException("getLocale");
    }

    public Enumeration<Locale> getLocales() {
        throw new UnsupportedOperationException("getLocales");
    }

    public boolean isSecure() {
        return "https".equals(this.getScheme());
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        throw new UnsupportedOperationException("getRequestDispatcher");
    }

    public int getRemotePort() {
        throw new UnsupportedOperationException("getRemotePort");
    }

    public String getLocalName() {
        throw new UnsupportedOperationException("getLocalName");
    }

    public String getLocalAddr() {
        return this.obj.getmember(LOCAL_ADDR).string();
    }

    public int getLocalPort() {
        return this.getServerPort();
    }

    public ServletContext getServletContext() {
        throw new UnsupportedOperationException("getServletContext");
    }

    public AsyncContext startAsync() throws IllegalStateException {
        throw new UnsupportedOperationException("startAsync");
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        throw new UnsupportedOperationException("startAsync");
    }

    public boolean isAsyncStarted() {
        return false;
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public AsyncContext getAsyncContext() {
        throw new UnsupportedOperationException("getAsyncContext");
    }

    public DispatcherType getDispatcherType() {
        throw new UnsupportedOperationException("getDispatcherType");
    }

    public String getAuthType() {
        return null;
    }

    public Cookie[] getCookies() {
        if (this.cookies == null) {
            String header = this.getHeader("Cookie");
            if (header != null) {
                String[] carray = header.split(";");
                if (carray != null) {
                    this.cookies = new ArrayList<Cookie>(carray.length);
                    for (String c : carray) {
                        String[] nvpair = c.split("=", -1);
                        if (nvpair.length != 2) continue;
                        String name = nvpair[0].trim();
                        try {
                            this.cookies.add(new Cookie(name, nvpair[1]));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                } else {
                    this.cookies = CollectionSupport.emptyList();
                }
            } else {
                this.cookies = CollectionSupport.emptyList();
            }
        }
        if (this.cookies.isEmpty()) {
            return null;
        }
        return this.cookies.toArray(new Cookie[this.cookies.size()]);
    }

    public long getDateHeader(String name) {
        if (name == null) {
            return -1L;
        }
        DDF h = this.obj.getmember("headers").getmember(name);
        if (h.isstring()) {
            try {
                SimpleDateFormat formatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
                formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
                Date d = formatter.parse(h.string());
                if (d != null) {
                    return d.getTime();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1L;
    }

    public String getHeader(String name) {
        if (name == null) {
            return null;
        }
        return RemotedHttpServletRequest.decodeUnsafeString(this.obj.getmember("headers").getmember(name).unsafe_string(), this.decoder, null);
    }

    public Enumeration<String> getHeaders(String name) {
        if (name == null) {
            return Collections.emptyEnumeration();
        }
        String s = RemotedHttpServletRequest.decodeUnsafeString(this.obj.getmember("headers").getmember(name).unsafe_string(), this.decoder, null);
        if (s != null) {
            return Collections.enumeration(Collections.singletonList(s));
        }
        return Collections.emptyEnumeration();
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.obj.getmember("headers").asMap().keySet());
    }

    public int getIntHeader(String name) {
        if (name == null) {
            return -1;
        }
        DDF h = this.obj.getmember("headers").getmember(name);
        if (h.isstring()) {
            return Integer.parseInt(RemotedHttpServletRequest.decodeUnsafeString(h.unsafe_string(), this.decoder, null));
        }
        return -1;
    }

    public String getMethod() {
        return this.obj.getmember(METHOD).string();
    }

    public String getPathInfo() {
        throw new UnsupportedOperationException("getPathInfo");
    }

    public String getPathTranslated() {
        return null;
    }

    public String getContextPath() {
        return "";
    }

    public String getQueryString() {
        return this.obj.getmember(QUERY_STRING).string();
    }

    public String getRemoteUser() {
        return this.obj.getmember("remote_user").string();
    }

    public boolean isUserInRole(String role) {
        return false;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public String getRequestedSessionId() {
        return null;
    }

    public String getRequestURI() {
        return RemotedHttpServletRequest.decodeUnsafeString(this.obj.getmember(REQUEST_URI).unsafe_string(), this.decoder, Character.valueOf('?'));
    }

    public StringBuffer getRequestURL() {
        String url = RemotedHttpServletRequest.decodeUnsafeString(this.obj.getmember(REQUEST_URL).unsafe_string(), this.decoder, Character.valueOf('?'));
        return new StringBuffer(url != null ? url : "");
    }

    public String getServletPath() {
        throw new UnsupportedOperationException();
    }

    public HttpSession getSession(boolean create) {
        if (create) {
            throw new UnsupportedOperationException("getSession");
        }
        return null;
    }

    public HttpSession getSession() {
        return null;
    }

    public String changeSessionId() {
        throw new UnsupportedOperationException("changeSessionId");
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        throw new UnsupportedOperationException("authenticate");
    }

    public void login(String username, String password) throws ServletException {
        throw new UnsupportedOperationException("login");
    }

    public void logout() throws ServletException {
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return null;
    }

    public Part getPart(String name) throws IOException, ServletException {
        return null;
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
        throw new UnsupportedOperationException("upgrade");
    }

    @Nullable
    public static String decodeUnsafeString(byte[] buffer, @Nonnull CharsetDecoder decoder, @Nullable Character delim) {
        if (buffer == null) {
            return null;
        }
        ByteBuffer wrapper = ByteBuffer.wrap(buffer);
        try {
            int index;
            String decoded = decoder.decode(wrapper).toString();
            int n = index = delim != null ? decoded.indexOf(delim.charValue()) : 0;
            if (index > 0) {
                return decoded.substring(0, index);
            }
            return decoded;
        }
        catch (CharacterCodingException characterCodingException) {
            return null;
        }
    }

    private static class BodyInputStream
    extends ServletInputStream {
        @Nonnull
        private final InputStream delegate;

        public BodyInputStream(byte[] body) {
            this.delegate = new ByteArrayInputStream(body);
        }

        public boolean isFinished() {
            return false;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
            throw new UnsupportedOperationException();
        }

        public int read() throws IOException {
            return this.delegate.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.delegate.read(b, off, len);
        }

        public int read(byte[] b) throws IOException {
            return this.delegate.read(b);
        }

        public long skip(long n) throws IOException {
            return this.delegate.skip(n);
        }

        public int available() throws IOException {
            return this.delegate.available();
        }

        public void close() throws IOException {
            this.delegate.close();
        }

        public synchronized void mark(int readlimit) {
            this.delegate.mark(readlimit);
        }

        public synchronized void reset() throws IOException {
            this.delegate.reset();
        }

        public boolean markSupported() {
            return this.delegate.markSupported();
        }
    }
}

