/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.profile.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.sp.context.AgentRequestContext;
import net.shibboleth.sp.ddf.DDF;
import net.shibboleth.sp.profile.AbstractAgentRequestAction;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.EventContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.CurrentOrPreviousEventLookup;

public class PrepareAgentErrorResponse
extends AbstractAgentRequestAction {
    @Nonnull
    private Function<ProfileRequestContext, EventContext> eventContextLookupStrategy;

    public PrepareAgentErrorResponse() {
        this.setAgentRequestContextLookupStrategy((Function)new ChildContextLookup(AgentRequestContext.class, true));
        this.eventContextLookupStrategy = new CurrentOrPreviousEventLookup();
    }

    public void setEventContextLookupStrategy(@Nonnull Function<ProfileRequestContext, EventContext> strategy) {
        this.checkSetterPreconditions();
        this.eventContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"EventContext lookup strategy cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        EventContext eventCtx;
        Object event;
        AgentRequestContext agentContext = this.ensureAgentRequestContext();
        DDF output = agentContext.getOutput();
        if (output == null) {
            output = new DDF().structure();
            agentContext.setOutput(output);
        }
        Object object = event = (eventCtx = this.eventContextLookupStrategy.apply(profileRequestContext)) != null ? eventCtx.getEvent() : null;
        if (event != null) {
            String eventString = event.toString();
            output.addmember("event").string(eventString);
        } else {
            output.addmember("event").string("MessageProcessingError");
        }
        byte[] target = agentContext.getTargetURL();
        if (target != null) {
            output.addmember("target").unsafe_string(target);
        }
    }
}

