/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.profile.impl;

import java.io.IOException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.sp.context.AgentRequestContext;
import net.shibboleth.sp.ddf.DDF;
import net.shibboleth.sp.messaging.RemotedHttpServletRequest;
import net.shibboleth.sp.messaging.RemotedHttpServletRequestResponseContext;
import net.shibboleth.sp.messaging.RemotedHttpServletResponse;
import net.shibboleth.sp.profile.AbstractApplicationAction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class MapStateTokenToResource
extends AbstractApplicationAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(MapStateTokenToResource.class);
    @NonnullAfterInit
    private Function<ProfileRequestContext, String> stateTokenLookupStrategy;

    public void setStateTokenLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.stateTokenLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"State token lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.stateTokenLookupStrategy == null) {
            throw new ComponentInitializationException("State token lookup strategy cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (this.ensureAgentRequestContext().getTargetURL() != null) {
            this.log.debug("{} Target URL already populated, skipping state token processing", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        AgentRequestContext agentRequestContext = this.ensureAgentRequestContext();
        try {
            byte[] target;
            RemotedHttpServletRequestResponseContext.loadCurrent((RemotedHttpServletRequest)agentRequestContext.getRemotedHttpServletRequest(), (RemotedHttpServletResponse)agentRequestContext.getRemotedHttpServletResponse());
            String token = this.stateTokenLookupStrategy.apply(profileRequestContext);
            if (token == null) {
                this.log.debug("{} No state token returned from lookup strategy, nothing to do", (Object)this.getLogPrefix());
                return;
            }
            DDF input = agentRequestContext.getInput();
            if (input != null) {
                input.addmember("state").string(token);
            }
            if ((target = this.ensureApplication().getStateTokenManager().recoverFromStateToken(this.ensureAgent(), this.ensureApplication(), token)) != null) {
                agentRequestContext.setTargetURL(target);
                this.log.debug("{} Requested resource recovered from state token: {}", (Object)this.getLogPrefix(), (Object)target);
            } else {
                this.log.warn("{} Unable to recover requested resource from state token", (Object)this.getLogPrefix());
            }
        }
        catch (IOException e) {
            this.log.warn("{} Exception recovering requested resource from state token", (Object)this.getLogPrefix(), (Object)e);
        }
        finally {
            RemotedHttpServletRequestResponseContext.clearCurrent();
        }
    }
}

