/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.profile.impl;

import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import java.io.IOException;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.profile.relyingparty.RelyingPartyConfiguration;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import net.shibboleth.sp.ddf.DDF;
import net.shibboleth.sp.messaging.RemotedHttpServletRequestResponseContext;
import net.shibboleth.sp.messaging.RemotedHttpServletResponse;
import net.shibboleth.sp.profile.AbstractApplicationAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class IssueDiscoveryRequest
extends AbstractApplicationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(IssueDiscoveryRequest.class);
    @NonnullAfterInit
    private Function<ProfileRequestContext, String> discoveryURLLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, String> issuerLookupStrategy = new ApplicationDefaultIssuerStrategy();
    @Nonnull
    private Predicate<ProfileRequestContext> passiveCondition = new DefaultPassiveCondition();
    @NonnullBeforeExec
    private DDF input;
    @NonnullBeforeExec
    private String discoveryURL;
    @NonnullBeforeExec
    private String issuer;
    @NonnullBeforeExec
    private String returnURL;
    @Nullable
    private String state;

    public void setDiscoveryURLLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.discoveryURLLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Discovery URL lookup strategy cannot be null");
    }

    public void setIssuerLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.issuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Issuer lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.discoveryURLLookupStrategy == null) {
            throw new ComponentInitializationException("Discovery URL lookup strategy cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.discoveryURL = this.discoveryURLLookupStrategy.apply(profileRequestContext);
        if (this.discoveryURL == null) {
            this.log.error("{} Unable to obtain discovery URL for request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"MessageProcessingError");
            return false;
        }
        this.issuer = this.issuerLookupStrategy.apply(profileRequestContext);
        if (this.issuer == null) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"MessageProcessingError");
            this.log.error("{} Unable to obtain entityID parameter value for discovery request", (Object)this.getLogPrefix());
            return false;
        }
        this.input = this.ensureAgentRequestContext().getInput();
        if (this.input == null) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            this.log.error("{} No input message from agent", (Object)this.getLogPrefix());
            return false;
        }
        this.state = this.input.getmember("state").string();
        this.returnURL = this.input.getmember("disco_return_url").string();
        if (this.returnURL == null) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            this.log.error("{} No '{}' input parameter from agent", (Object)this.getLogPrefix(), (Object)"disco_return_url");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        Escaper escaper = UrlEscapers.urlFormParameterEscaper();
        if (this.state != null) {
            this.returnURL = this.returnURL + escaper.escape("&state=" + escaper.escape(this.state));
        }
        this.discoveryURL = this.discoveryURL + (this.discoveryURL.indexOf(63) > 0 ? (char)'&' : '?') + "return=" + this.returnURL + "&entityID=" + escaper.escape(this.issuer);
        if (this.passiveCondition.test(profileRequestContext)) {
            this.discoveryURL = this.discoveryURL + "&isPassive=true";
        }
        this.ensureOutputObjects();
        try {
            RemotedHttpServletRequestResponseContext.loadCurrent(null, (RemotedHttpServletResponse)this.ensureAgentRequestContext().getRemotedHttpServletResponse());
            this.ensureHttpServletResponse().sendRedirect(this.discoveryURL);
        }
        catch (IOException e) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
            this.log.error("{} I/O error issuing remoted discovery redirect", (Object)this.getLogPrefix(), (Object)e);
        }
        finally {
            RemotedHttpServletRequestResponseContext.clearCurrent();
        }
    }

    private class ApplicationDefaultIssuerStrategy
    implements Function<ProfileRequestContext, String> {
        private ApplicationDefaultIssuerStrategy() {
        }

        @Override
        @Nullable
        public String apply(@Nullable ProfileRequestContext input) {
            try {
                RelyingPartyConfiguration rpConfig = (RelyingPartyConfiguration)IssueDiscoveryRequest.this.ensureApplication().resolveSingle((Object)new CriteriaSet());
                if (rpConfig != null) {
                    return rpConfig.getIssuer(input);
                }
            }
            catch (ResolverException e) {
                IssueDiscoveryRequest.this.log.error("{} Error resolving RelyingPartyConfiguration", (Object)IssueDiscoveryRequest.this.getLogPrefix(), (Object)e);
            }
            return null;
        }
    }

    private class DefaultPassiveCondition
    implements Predicate<ProfileRequestContext> {
        private DefaultPassiveCondition() {
        }

        @Override
        public boolean test(@Nullable ProfileRequestContext t) {
            return Integer.valueOf(1).equals(IssueDiscoveryRequest.this.input.getmember("isPassive").integer()) || "none".equals(IssueDiscoveryRequest.this.input.getmember("prompt").string());
        }
    }
}

