/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.profile.impl;

import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.net.CookieManager;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.sp.context.AgentRequestContext;
import net.shibboleth.sp.ddf.DDF;
import net.shibboleth.sp.messaging.RemotedHttpServletRequest;
import net.shibboleth.sp.messaging.RemotedHttpServletRequestResponseContext;
import net.shibboleth.sp.messaging.RemotedHttpServletResponse;
import net.shibboleth.sp.profile.AbstractApplicationAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class IssueCorrelationCookie
extends AbstractApplicationAction {
    @Nonnull
    @NotEmpty
    public static String DEFAULT_COOKIE_PREFIX = "_shibsp_req_";
    @Nonnull
    private Logger log = LoggerFactory.getLogger(IssueCorrelationCookie.class);
    @NonnullAfterInit
    private CookieManager cookieManager;
    @Nonnull
    private String cookiePrefix = DEFAULT_COOKIE_PREFIX;
    private boolean errorFatal;
    @NonnullAfterInit
    private Function<ProfileRequestContext, String> requestIDLookupStrategy;
    @NonnullBeforeExec
    private String stateToken;
    @NonnullBeforeExec
    private String requestID;

    public void setCookieManager(@Nonnull CookieManager manager) {
        this.checkSetterPreconditions();
        this.cookieManager = (CookieManager)Constraint.isNotNull((Object)manager, (String)"CookieManager cannot be null");
    }

    public void setCookiePrefix(@Nonnull @NotEmpty String prefix) {
        this.checkSetterPreconditions();
        this.cookiePrefix = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)prefix), (String)"Cookie prefix cannot be null or empty");
    }

    public void setErrorFatal(boolean flag) {
        this.checkSetterPreconditions();
        this.errorFatal = flag;
    }

    public void setRequestIDLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.requestIDLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Request ID lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.cookieManager == null) {
            throw new ComponentInitializationException("CookieManager cannot be null");
        }
        if (this.requestIDLookupStrategy == null) {
            throw new ComponentInitializationException("Request ID lookup strategy cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.requestID = this.requestIDLookupStrategy.apply(profileRequestContext);
        if (this.requestID == null) {
            this.log.debug("{} No request message ID available, skipping creation of correlation cookie", (Object)this.getLogPrefix());
            return false;
        }
        DDF input = this.ensureAgentRequestContext().getInput();
        if (input != null) {
            this.stateToken = input.getmember("state").string();
        }
        if (this.stateToken == null) {
            if (this.requestID != null) {
                if (this.errorFatal) {
                    this.log.warn("{} Input was missing {} parameter", (Object)this.getLogPrefix(), (Object)"state");
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
                } else {
                    this.log.debug("{} Input was missing {} parameter, skipping creation of correlation cookie", (Object)this.getLogPrefix(), (Object)"state");
                }
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        this.ensureOutputObjects();
        AgentRequestContext agentRequestContext = this.ensureAgentRequestContext();
        try {
            RemotedHttpServletRequestResponseContext.loadCurrent((RemotedHttpServletRequest)agentRequestContext.getRemotedHttpServletRequest(), (RemotedHttpServletResponse)agentRequestContext.getRemotedHttpServletResponse());
            this.cookieManager.purgeStaleCookies(this.cookiePrefix);
            this.log.debug("{} Tracking request ID {} against state token {}", new Object[]{this.getLogPrefix(), this.requestID, this.stateToken});
            Escaper escaper = UrlEscapers.urlFormParameterEscaper();
            this.cookieManager.addCookie(this.cookiePrefix + escaper.escape(this.stateToken), escaper.escape(this.requestID));
        }
        finally {
            RemotedHttpServletRequestResponseContext.clearCurrent();
        }
    }
}

