/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.profile.impl;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.sp.ddf.DDF;
import net.shibboleth.sp.profile.AbstractAgentAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageService;
import org.opensaml.storage.VersionMismatchException;
import org.slf4j.Logger;

public class DoStorageOperation
extends AbstractAgentAction {
    @Nonnull
    @NotEmpty
    public static final String RECORD_NOT_FOUND = "RecordNotFound";
    @Nonnull
    @NotEmpty
    public static final String DUPLICATE_RECORD = "DuplicateRecord";
    @Nonnull
    @NotEmpty
    public static final String VERSION_MISMATCH = "VersionMismatch";
    @Nonnull
    @NotEmpty
    public static final String CONTEXT = "context";
    @Nonnull
    @NotEmpty
    public static final String KEY = "key";
    @Nonnull
    @NotEmpty
    public static final String VALUE = "value";
    @Nonnull
    @NotEmpty
    public static final String EXP = "exp";
    @Nonnull
    @NotEmpty
    public static final String VERSION = "version";
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DoStorageOperation.class);
    @NonnullAfterInit
    private StorageService storageService;
    @NonnullBeforeExec
    private DDF input;

    public void setStorageService(@Nonnull StorageService storage) {
        this.checkSetterPreconditions();
        this.storageService = (StorageService)Constraint.isNotNull((Object)storage, (String)"StorageService cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.storageService == null) {
            throw new ComponentInitializationException("StorageService cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (this.getHttpServletRequest() == null) {
            this.log.warn("{} No HttpServletRequest available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.input = this.ensureAgentRequestContext().getInput();
        if (this.input == null || !this.input.isstruct()) {
            this.log.warn("{} Invalid or missing input message", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        try {
            HttpServletRequest request = this.ensureHttpServletRequest();
            if ("GET".equals(request.getMethod())) {
                this.doRead(profileRequestContext);
            } else if ("PUT".equals(request.getMethod())) {
                this.doCreate(profileRequestContext);
            } else if ("POST".equals(request.getMethod())) {
                this.doUpdate(profileRequestContext);
            } else if ("DELETE".equals(request.getMethod())) {
                this.doDelete(profileRequestContext);
            } else {
                this.log.warn("{} Invalid method: {}", (Object)this.getLogPrefix(), (Object)request.getMethod());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            }
        }
        catch (IOException e) {
            this.log.error("{} I/O error responding to request", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
        }
    }

    private void doRead(@Nonnull ProfileRequestContext profileRequestContext) throws IOException {
        Object context = this.input.getmember(CONTEXT).string();
        String key = this.input.getmember(KEY).string();
        if (context == null || key == null) {
            this.log.warn("{} Context and key are required members for read operation", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
        context = this.ensureAgent().getId() + "!" + (String)context;
        StorageRecord record = this.storageService.read((String)context, key);
        if (record != null) {
            DDF output = new DDF().structure();
            output.addmember(VALUE).string(record.getValue());
            output.addmember(VERSION).longinteger(record.getVersion());
            Long exp = record.getExpiration();
            if (exp != null) {
                output.addmember(EXP).longinteger(exp / 1000L);
            }
            this.ensureAgentRequestContext().setOutput(output);
        } else {
            this.log.trace("{} No record found with context ({}), key ({})", new Object[]{this.getLogPrefix(), context, key});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)RECORD_NOT_FOUND);
        }
    }

    private void doCreate(@Nonnull ProfileRequestContext profileRequestContext) throws IOException {
        Object context = this.input.getmember(CONTEXT).string();
        String key = this.input.getmember(KEY).string();
        String value = this.input.getmember(VALUE).string();
        if (context == null || key == null || value == null) {
            this.log.warn("{} Context, key, and value are required members for create operation", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
        context = this.ensureAgent().getId() + "!" + (String)context;
        Long exp = this.input.getmember(EXP).longinteger();
        if (exp != null) {
            exp = exp * 1000L;
        }
        if (this.storageService.create((String)context, key, value, exp)) {
            this.log.trace("{} Created record with context ({}), key ({}), expiration ({})", new Object[]{this.getLogPrefix(), context, key, exp});
        } else {
            this.log.warn("{} Record exists with context ({}), key ({})", new Object[]{this.getLogPrefix(), context, key});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)DUPLICATE_RECORD);
        }
    }

    private void doUpdate(@Nonnull ProfileRequestContext profileRequestContext) throws IOException {
        block11: {
            Object context = this.input.getmember(CONTEXT).string();
            String key = this.input.getmember(KEY).string();
            String value = this.input.getmember(VALUE).string();
            if (context == null || key == null || value == null) {
                this.log.warn("{} Context, key, and value are required members for update operation", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
                return;
            }
            context = this.ensureAgent().getId() + "!" + (String)context;
            Long version = this.input.getmember(VERSION).longinteger();
            Long exp = this.input.getmember(EXP).longinteger();
            if (exp != null) {
                exp = exp * 1000L;
            }
            if (version != null) {
                try {
                    version = this.storageService.updateWithVersion(version.longValue(), (String)context, key, value, exp);
                    if (version != null) {
                        this.log.trace("{} Updated record with context ({}), key ({}), version ({})", new Object[]{this.getLogPrefix(), context, key, version});
                        DDF output = new DDF().structure();
                        output.addmember(VERSION).longinteger(version.longValue());
                        this.ensureAgentRequestContext().setOutput(output);
                        break block11;
                    }
                    this.log.info("{} No record to update with context ({}), key ({})", new Object[]{this.getLogPrefix(), context, key});
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)RECORD_NOT_FOUND);
                }
                catch (VersionMismatchException e) {
                    this.log.info("{} Existing record with context ({}), key ({}). but version ({})", new Object[]{this.getLogPrefix(), context, key, version});
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)VERSION_MISMATCH);
                }
            } else if (this.storageService.update((String)context, key, value, exp)) {
                this.log.trace("{} Updated record with context ({}), key ({}), expiration ({})", new Object[]{this.getLogPrefix(), context, key, exp});
            } else if (this.storageService.create((String)context, key, value, exp)) {
                this.log.trace("{} Created record with context ({}), key ({}), expiration ({})", new Object[]{this.getLogPrefix(), context, key, exp});
            } else {
                this.log.warn("{} Failed to update or create record with context ({}), key ({})", new Object[]{this.getLogPrefix(), context, key});
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
            }
        }
    }

    private void doDelete(@Nonnull ProfileRequestContext profileRequestContext) throws IOException {
        Object context = this.input.getmember(CONTEXT).string();
        String key = this.input.getmember(KEY).string();
        if (context == null || key == null) {
            this.log.warn("{} Context and key are required members for delete operation", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
        context = this.ensureAgent().getId() + "!" + (String)context;
        if (this.storageService.delete((String)context, key)) {
            this.log.trace("{} Deleted record with context ({}), key ({})", new Object[]{this.getLogPrefix(), context, key});
        } else {
            this.log.trace("{} No record to delete with context ({}), key ({})", new Object[]{this.getLogPrefix(), context, key});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)RECORD_NOT_FOUND);
        }
    }
}

